/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/constants/StringConst
 */
define(['baja!', 'nmodule/webEditors/rc/baja/bajaUtils'], function (baja, bajaUtils) {
  'use strict';

  var Component = baja.Component,
      proxySlotFacets = bajaUtils.proxySlotFacets;
  /**
   * BajaScript representation of a `kitControl:StringConst` value.
   *
   * @class
   * @extends {baja.Component}
   * @alias {module:nmodule/kitControl/rc/baja/constants/StringConst}
   */

  var StringConst = function StringConst() {
    Component.apply(this, arguments);
    proxySlotFacets(this, {
      '^(out|set)$': 'facets'
    });
  };

  StringConst.prototype = Object.create(Component.prototype);
  StringConst.prototype.constructor = StringConst;
  return StringConst;
});
