/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/constants/NumericConst
 */
define(['baja!', 'nmodule/webEditors/rc/baja/bajaUtils'], function (baja, bajaUtils) {
  'use strict';

  var Component = baja.Component,
      proxySlotFacets = bajaUtils.proxySlotFacets;
  /**
   * BajaScript representation of a `kitControl:NumericConst` value.
   *
   * @class
   * @extends {baja.Component}
   * @alias {module:nmodule/kitControl/rc/baja/constants/NumericConst}
   */

  var NumericConst = function NumericConst() {
    Component.apply(this, arguments);
    proxySlotFacets(this, {
      '^(out|set)$': 'facets'
    });
  };

  NumericConst.prototype = Object.create(Component.prototype);
  NumericConst.prototype.constructor = NumericConst;
  return NumericConst;
});
