/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/constants/EnumConst
 */
define(['baja!', 'nmodule/webEditors/rc/baja/bajaUtils'], function (baja, bajaUtils) {
  'use strict';

  var Component = baja.Component,
      proxySlotFacets = bajaUtils.proxySlotFacets;
  /**
   * BajaScript representation of a `kitControl:EnumConst` value.
   *
   * @class
   * @extends {baja.Component}
   * @alias {module:nmodule/kitControl/rc/baja/constants/EnumConst}
   */

  var EnumConst = function EnumConst() {
    Component.apply(this, arguments);
    proxySlotFacets(this, {
      '^(out|set)$': 'facets'
    });
  };

  EnumConst.prototype = Object.create(Component.prototype);
  EnumConst.prototype.constructor = EnumConst;
  return EnumConst;
});
