/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/constants/BooleanConst
 */
define(['baja!', 'nmodule/webEditors/rc/baja/bajaUtils'], function (baja, bajaUtils) {
  'use strict';

  var Component = baja.Component,
      proxySlotFacets = bajaUtils.proxySlotFacets;
  /**
   * BajaScript representation of a `kitControl:BooleanConst` value.
   *
   * @class
   * @extends {baja.Component}
   * @alias {module:nmodule/kitControl/rc/baja/constants/BooleanConst}
   */

  var BooleanConst = function BooleanConst() {
    Component.apply(this, arguments);
    proxySlotFacets(this, {
      '^(out|set)$': 'facets'
    });
  };

  BooleanConst.prototype = Object.create(Component.prototype);
  BooleanConst.prototype.constructor = BooleanConst;
  return BooleanConst;
});
