/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/KitNumeric
 */
define(['baja!', 'nmodule/webEditors/rc/baja/bajaUtils'], function (baja, bajaUtils) {
  'use strict';

  var Component = baja.Component,
      proxySlotFacets = bajaUtils.proxySlotFacets,
      propagateFacets = baja.Facets.make({
    fieldEditor: 'kitControl:PropagateFlagsFE',
    uxFieldEditor: 'kitControl:PropagateFlagsEditor'
  });
  /**
   * BajaScript representation of a `kitControl:KitNumeric` value.
   *
   * @class
   * @extends {baja.Component}
   * @alias {module:nmodule/kitControl/rc/baja/KitNumeric}
   */

  var KitNumeric = function KitNumeric() {
    Component.apply(this, arguments);
    proxySlotFacets(this, {
      '^propagateFlags$': propagateFacets,
      '^facets$': 'facets'
    });
  };

  KitNumeric.prototype = Object.create(Component.prototype);
  KitNumeric.prototype.constructor = KitNumeric;
  return KitNumeric;
});
