function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * Copyright 2019 Tridium, Inc. All Rights Reserved.
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/videoDriver/rc/widget/ControlPanelWidget
 */
define(['baja!', 'baja!videoDriver:VideoZoomEnum,videoDriver:VideoPanTiltEnum', 'bajaux/mixin/subscriberMixIn', 'bajaux/commands/Command', 'bajaux/commands/CommandGroup', 'bajaux/util/CommandButtonGroup', 'Promise', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/fe', 'nmodule/videoDriver/rc/rpc/rpc', 'bajaux/mixin/responsiveMixIn', 'css!nmodule/videoDriver/rc/videoDriver'], function (baja, types, subscriberMixIn, Command, CommandGroup, CommandButtonGroup, Promise, BaseEditor, fe, rpc, responsiveMixIn) {
  'use strict';

  var tpl = function tpl() {
    return "<div class=\"ControlPanelContainer\">\n                        <div class=\"controls panRight\"/>\n                        <div class=\"controls panRightTiltUp\" />    \n                        <div class=\"controls tiltUp\" />\n                        <div class=\"controls panLeftTiltUp\" />\n                        <div class=\"controls panLeft\" />\n                        <div class=\"controls panLeftTiltDown\" />\n                        <div class=\"controls tiltDown\" />\n                        <div class=\"controls panRightTiltDown\" />\n                        <div class=\"controls zoomControls\" />                        \n                      </div>";
  };

  var move = rpc.move,
      zoom = rpc.zoom;
  var NONE_INTERVAL = 200;
  /**
   * Widget for controlling the pan, tilt and zoom of a chosen camera. Handles
   * slow, medium and fast pan and tilt of a camera. Handles mediumZoomIn and mediumZoomOut
   * of a camera.
   *
   * @class
   * @alias module:nmodule/videoDriver/rc/widget/ControlPanelWidget
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   */

  return /*#__PURE__*/function (_BaseEditor) {
    _inherits(ControlPanelWidget, _BaseEditor);

    var _super = _createSuper(ControlPanelWidget);

    function ControlPanelWidget(params) {
      var _this;

      _classCallCheck(this, ControlPanelWidget);

      _this = _super.call(this, params);
      subscriberMixIn(_assertThisInitialized(_this));
      responsiveMixIn(_assertThisInitialized(_this), {
        'xxsmall-fit': function xxsmallFit(jq) {
          return Math.min(jq.width, jq.height) <= 50;
        },
        'xsmall-fit': function xsmallFit(jq) {
          return Math.min(jq.width, jq.height) > 50 && Math.min(jq.width, jq.height) <= 150;
        },
        'small-fit': function smallFit(jq) {
          return Math.min(jq.width, jq.height) > 150 && Math.min(jq.width, jq.height) <= 200;
        },
        'medium-fit': function mediumFit(jq) {
          return Math.min(jq.width, jq.height) > 200 && Math.min(jq.width, jq.height) <= 300;
        },
        'medium-large-fit': function mediumLargeFit(jq) {
          return Math.min(jq.width, jq.height) > 300 && Math.min(jq.width, jq.height) <= 400;
        },
        'large-fit': function largeFit(jq) {
          return Math.min(jq.width, jq.height) > 400 && Math.min(jq.width, jq.height) <= 500;
        },
        'xlarge-fit': function xlargeFit(jq) {
          return Math.min(jq.width, jq.height) > 500 && Math.min(jq.width, jq.height) <= 600;
        },
        'xxlarge-fit': function xxlargeFit(jq) {
          return Math.min(jq.width, jq.height) > 600 && Math.min(jq.width, jq.height) <= 700;
        },
        'xxxlarge-fit': function xxxlargeFit(jq) {
          return Math.min(jq.width, jq.height) > 700 && Math.min(jq.width, jq.height) <= 800;
        },
        'free-fit': function freeFit(jq) {
          return Math.min(jq.width, jq.height) > 800;
        }
      });
      return _this;
    }
    /**
     * Gives out a command with a user specified handler.
     *
     * @private
     * @param {string} lex
     * @param {Function} func
     * @returns {module:bajaux/commands/Command}
     */


    _createClass(ControlPanelWidget, [{
      key: "$cmd",
      value: function $cmd(lex, func) {
        return new Command({
          module: 'videoDriver',
          lex: lex,
          func: func
        });
      }
    }, {
      key: "$makeCmdGrp",

      /**
       * Returns a command group with the input command array.
       *
       * @private
       * @param {Array<module:bajaux/commands/Command>} cmdArr
       * @returns {module:bajaux/commands/CommandGroup}
       */
      value: function $makeCmdGrp(cmdArr) {
        return new CommandGroup({
          commands: cmdArr
        });
      }
    }, {
      key: "$makeCommandsForPanTilt",

      /**
       * Makes the command objects to interact with Pan and Tilt options of a camera.
       *
       * @private
       * @returns {baja.OrderedMap} groupCmdMap - OrderedMap with Pan and Tilt Commands.
       */
      value: function $makeCommandsForPanTilt() {
        var _this2 = this;

        var cmdArr = [],
            groupCmdMap = new baja.OrderedMap(),
            videoPanTiltEnum = baja.$('videoDriver:VideoPanTiltEnum'),
            ordinalLength = videoPanTiltEnum.getRange().getOrdinals().length - 1; // Enum 'None" is not considered.

        var _loop = function _loop(ordinalIndex) {
          var curEnum = videoPanTiltEnum.make(ordinalIndex),
              tag = curEnum.getTag();

          var inCmd = _this2.$cmd(tag, function () {
            move(_this2.value().getNavOrd(), tag);

            _this2.$triggerNoneMoveCommand();
          });

          cmdArr.push(inCmd); // Segregating the slow, medium, fast commands to an independent command group.
          // For every index (3, 6, 9, 12, 15, 18, 21, 24) of the fast command, modulus will be returning a zero.

          if (ordinalIndex % 3 === 0) {
            // Use the class name without the 'speed' operator.
            var className = tag.replace('Fast', '');
            groupCmdMap.put(className, _this2.$makeCmdGrp(cmdArr));
            cmdArr = [];
          }
        };

        for (var ordinalIndex = 1; ordinalIndex <= ordinalLength; ordinalIndex++) {
          _loop(ordinalIndex);
        }

        return groupCmdMap;
      }
      /**
       * @private
       */

    }, {
      key: "$triggerNoneZoomCommand",
      value: function $triggerNoneZoomCommand() {
        var _this3 = this;

        setTimeout(function () {
          return zoom(_this3.value().getNavOrd(), 'none');
        }, NONE_INTERVAL);
      }
      /**
       * @private
       */

    }, {
      key: "$triggerNoneMoveCommand",
      value: function $triggerNoneMoveCommand() {
        var _this4 = this;

        setTimeout(function () {
          return move(_this4.value().getNavOrd(), 'none');
        }, NONE_INTERVAL);
      }
      /**
       * Makes the command object for zoom.
       *
       * @returns {baja.OrderedMap} zoomMap - OrderedMap of zoomInMedium and zoomOutMedium commands.
       */

    }, {
      key: "$makeCommandsForZoom",
      value: function $makeCommandsForZoom() {
        var _this5 = this;

        var cmdArr = [this.$cmd('videoDriver.zoomIn', function () {
          zoom(_this5.value().getNavOrd(), 'zoomInMedium');

          _this5.$triggerNoneZoomCommand();
        }), this.$cmd('videoDriver.zoomOut', function () {
          zoom(_this5.value().getNavOrd(), 'zoomOutMedium');

          _this5.$triggerNoneZoomCommand();
        })];
        var zoomMap = new baja.OrderedMap();
        zoomMap.put('zoom', this.$makeCmdGrp(cmdArr));
        return zoomMap;
      }
      /**
       * Lifecycle initialize method.
       *
       * @param {JQuery} dom
       * @returns {Promise}
       */

    }, {
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this6 = this;

        dom.addClass('ControlPanelWidget').html(tpl());
        this.$panTiltCmdMap = this.$makeCommandsForPanTilt();
        this.$zoomControlMap = this.$makeCommandsForZoom();
        var promiseArr = [];
        this.$panTiltCmdMap.getKeys().forEach(function (className) {
          promiseArr.push(fe.buildFor({
            dom: _this6.jq().find('.' + className),
            value: _this6.$panTiltCmdMap.get(className),
            type: CommandButtonGroup,
            properties: {
              toolbar: true
            },
            formFactor: 'mini'
          }));
        });
        promiseArr.push(fe.buildFor({
          dom: this.jq().find('.zoomControls'),
          value: this.$zoomControlMap.get('zoom'),
          type: CommandButtonGroup,
          properties: {
            toolbar: true
          },
          formFactor: 'mini'
        }));
        return Promise.all(promiseArr);
      }
      /**
       * Returns the pan and tilt command OrderedMap.
       *
       * @returns {baja.OrderedMap} panTiltCmdMap - OrderedMap with Pan and Tilt Commands.
       */

    }, {
      key: "getPanTiltCommands",
      value: function getPanTiltCommands() {
        return this.$panTiltCmdMap;
      }
      /**
       * Returns the zoomInMedium and zoomOutMedium command group.
       *
       * @returns {baja.OrderedMap}
       */

    }, {
      key: "getZoomCommands",
      value: function getZoomCommands() {
        return this.$zoomControlMap;
      }
      /**
       * Destroys the dom and associated child elements.
       */

    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('ControlPanelWidget');
        return this.getChildWidgets().destroyAll();
      }
    }]);

    return ControlPanelWidget;
  }(BaseEditor);
});
