function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/videoDriver/rc/live/stream/StreamSettingsWidget
 */
define(['baja!', 'baja!videoDriver:VideoCompressionEnum,videoDriver:VideoFrameRateEnum,' + 'videoDriver:VideoResolutionEnum', 'lex!videoDriver', 'log!nmodule.videoDriver.rc.fe.playback.StreamSettingsWidget', 'bajaux/events', 'nmodule/videoDriver/rc/live/stream/StreamConfigurationMixin', 'nmodule/videoDriver/rc/live/stream/StreamSettings', 'nmodule/webEditors/rc/fe/CompositeEditor', 'nmodule/webEditors/rc/fe/config/CompositeBuilder', 'nmodule/webEditors/rc/wb/mixin/mixinUtils'], function (baja, types, lexs, log, events, StreamConfigurationMixin, StreamSettings, CompositeEditor, CompositeBuilder, mixinUtils) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
      videoDriverLex = _lexs[0];

  var MODIFY_EVENT = events.MODIFY_EVENT;
  var hasMixin = mixinUtils.hasMixin;
  var BANDWIDTH_DISPLAY_CHANGE_EVENT = StreamConfigurationMixin.BANDWIDTH_DISPLAY_CHANGE_EVENT,
      MIXIN_NAME = StreamConfigurationMixin.MIXIN_NAME;
  var logSevere = log.severe.bind(log);
  var KEYS_TO_TYPE = {
    'preferredResolution': 'videoDriver:VideoResolutionEnum',
    'preferredFrameRate': 'videoDriver:VideoFrameRateEnum',
    'preferredCompression': 'videoDriver:VideoCompressionEnum'
  };

  var getKeys = function getKeys() {
    return Object.keys(KEYS_TO_TYPE);
  };

  var tpl = function tpl(_ref) {
    var bandwidthDisplay = _ref.bandwidthDisplay,
        preferredResolution = _ref.preferredResolution,
        preferredFrameRate = _ref.preferredFrameRate,
        preferredCompression = _ref.preferredCompression;
    return "\n    <table class=\"ux-table\">\n      <tr class=\"ux-table-row\"><td>".concat(bandwidthDisplay, "</td><td class=\"bandwidthDisplay\"></td></tr>\n      <tr class=\"ux-table-row\"><td>").concat(preferredResolution, "</td><td class=\"preferredResolution\"></td></tr>\n      <tr class=\"ux-table-row\"><td>").concat(preferredFrameRate, "</td><td class=\"preferredFrameRate\"></td></tr>\n      <tr class=\"ux-table-row\"><td>").concat(preferredCompression, "</td><td class=\"preferredCompression\"></td></tr>\n    </table>");
  };
  /**
   * Allows configuration of video stream quality settings.
   *
   * @class
   * @alias module:nmodule/videoDriver/rc/live/stream/StreamSettingsWidget
   * @extends module:nmodule/webEditors/rc/fe/CompositeEditor
   */


  return /*#__PURE__*/function (_CompositeEditor) {
    _inherits(StreamSettingsWidget, _CompositeEditor);

    var _super = _createSuper(StreamSettingsWidget);

    function StreamSettingsWidget() {
      _classCallCheck(this, StreamSettingsWidget);

      return _super.apply(this, arguments);
    }

    _createClass(StreamSettingsWidget, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this = this;

        dom.addClass('StreamSettingsWidget').html(tpl({
          bandwidthDisplay: videoDriverLex.getSafe('bandwidthDisplay'),
          preferredResolution: videoDriverLex.getSafe('preferredResolution'),
          preferredFrameRate: videoDriverLex.getSafe('preferredFrameRate'),
          preferredCompression: videoDriverLex.getSafe('preferredCompression')
        }));
        dom.on(MODIFY_EVENT, '*', function () {
          _this.read().then(function (settings) {
            return Promise.all([_this.value().applyStreamSettings(settings), settings.saveToUserData()]);
          })["catch"](logSevere);
        });
      }
      /**
       * @returns {module:nmodule/webEditors/rc/fe/config/CompositeBuilder} a builder
       * to show selectors for each stream setting property
       */

    }, {
      key: "makeBuilder",
      value: function makeBuilder() {
        var _this2 = this;

        var builder = new CompositeBuilder();
        builder.getKeys = getKeys;

        builder.getDomFor = function (key) {
          return _this2.jq().find('.' + key);
        };

        builder.getValueFor = function (key) {
          return baja.$(KEYS_TO_TYPE[key], _this2.$defaultSettings[key]);
        };

        builder.getConfigFor = function () {
          return {
            formFactor: 'mini'
          };
        };

        return builder;
      }
      /**
       * Load in the current configured settings (either saved by the user, or
       * defaults from the stream).
       *
       * @param {module:nmodule/videoDriver/rc/live/stream/StreamConfigurationMixin} videoStream
       * @returns {Promise}
       */

    }, {
      key: "doLoad",
      value: function doLoad(videoStream) {
        var _this3 = this,
            _arguments = arguments;

        if (!hasMixin(videoStream, MIXIN_NAME)) {
          throw new Error('StreamConfigurationMixin required');
        }

        var bandwidthListener = this.$bandwidthListener = function (display) {
          return _this3.$setBandwidthDisplay(display);
        };

        videoStream.on(BANDWIDTH_DISPLAY_CHANGE_EVENT, bandwidthListener);
        return StreamSettings.make(videoStream).then(function (defaultSettings) {
          _this3.$defaultSettings = defaultSettings;
          return _get(_getPrototypeOf(StreamSettingsWidget.prototype), "doLoad", _this3).apply(_this3, _arguments);
        });
      }
      /**
       * Read user-entered settings.
       * @returns {Promise<module:nmodule/videoDriver/rc/live/stream/StreamSettings>}
       */

    }, {
      key: "doRead",
      value: function doRead() {
        var keys = getKeys();
        var builder = this.getBuilder();
        return Promise.all(keys.map(function (key) {
          return builder.getEditorFor(key).read();
        })).then(function (enums) {
          var settings = {};
          keys.forEach(function (key, i) {
            settings[key] = enums[i].getTag();
          });
          return new StreamSettings(settings);
        });
      }
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        var videoStream = this.value();

        if (videoStream) {
          videoStream.removeListener(BANDWIDTH_DISPLAY_CHANGE_EVENT, this.$bandwidthListener);
        }

        this.jq().removeClass('StreamSettingsWidget');
        return _get(_getPrototypeOf(StreamSettingsWidget.prototype), "doDestroy", this).call(this);
      }
      /**
       * @private
       * @returns {JQuery}
       */

    }, {
      key: "$getBandwidthDisplayElement",
      value: function $getBandwidthDisplayElement() {
        return this.jq().find('.bandwidthDisplay');
      }
      /**
       * @private
       * @param {string} bandwidthDisplay
       */

    }, {
      key: "$setBandwidthDisplay",
      value: function $setBandwidthDisplay(bandwidthDisplay) {
        this.$getBandwidthDisplayElement().text(bandwidthDisplay);
      }
    }]);

    return StreamSettingsWidget;
  }(CompositeEditor);
});
