function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/videoDriver/rc/live/stream/StreamSettings
 */
define(['underscore', 'nmodule/webEditors/rc/servlets/userData'], function (_, userData) {
  'use strict';

  var USER_DATA_KEY = 'VideoStreamSettings';
  var DEFAULT_RESOLUTION = 'high';
  var DEFAULT_FRAME_RATE = 'high';
  var DEFAULT_COMPRESSION = 'medium';
  /**
   * Stream quality settings.
   *
   * @class
   * @alias module:nmodule/videoDriver/rc/live/stream/StreamSettings
   */

  return /*#__PURE__*/function () {
    /**
     * @param [params]
     * @param {string} params.preferredResolution a tag from `videoDriver:VideoResolutionEnum`
     * @param {string} params.preferredFrameRate a tag from `videoDriver:VideoFrameRateEnum`
     * @param {string} params.preferredCompression a tag from `videoDriver:VideoCompressionEnum`
     */
    function StreamSettings() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      _classCallCheck(this, StreamSettings);

      /** @type {string} */
      this.preferredResolution = params.preferredResolution || DEFAULT_RESOLUTION;
      /** @type {string} */

      this.preferredFrameRate = params.preferredFrameRate || DEFAULT_FRAME_RATE;
      /** @type {string} */

      this.preferredCompression = params.preferredCompression || DEFAULT_COMPRESSION;
    }
    /**
     * Retrieve the stream settings for this `VideoStream`. Will use the
     * settings saved by the user if present; otherwise lets the `VideoStream`
     * provide its own defaults.
     *
     * @param {module:nmodule/videoDriver/rc/live/stream/StreamConfigurationMixin} videoStream
     * @returns {Promise.<module:nmodule/videoDriver/rc/live/stream/StreamSettings>}
     */


    _createClass(StreamSettings, [{
      key: "saveToUserData",

      /**
       * Persist these settings to user data.
       *
       * @returns {Promise}
       */
      value: function saveToUserData() {
        return userData.put(USER_DATA_KEY, JSON.stringify(this));
      }
    }], [{
      key: "make",
      value: function make(videoStream) {
        return userData.get(USER_DATA_KEY).then(function (userSettings) {
          if (userSettings) {
            return new StreamSettings(JSON.parse(userSettings));
          }

          return videoStream.getDefaultStreamSettings();
        }).then(function (settings) {
          return new StreamSettings(settings || {});
        });
      }
    }]);

    return StreamSettings;
  }();
});
