function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan 
 */

/*eslint-env browser */

/**
* API Status: **Private**
* @module  module:nmodule/videoDriver/rc/live/ZoomControl
*/
define(['baja!', 'baja!videoDriver:VideoZoomEnum', 'bajaux/commands/Command', 'jquery', 'underscore', 'nmodule/videoDriver/rc/rpc/rpc', 'nmodule/webEditors/rc/fe/BaseWidget', 'log!nmodule.videoDriver.rc.live'], function (baja, types, Command, $, _, rpc, BaseWidget, log) {
  'use strict';

  var logInfo = log.info.bind(log);
  var DEFAULT_ZOOM_INTERVAL = 1000;
  var zoom = rpc.zoom;

  var tpl = function tpl(_ref) {
    var width = _ref.width,
        height = _ref.height;
    return "\n    <svg class=\"zoomSlider\" xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 ".concat(width, " ").concat(height, "\" preserveAspectRatio=\"none\"></svg>\n  ");
  };

  var getActionClass = function getActionClass(str) {
    var pattern = '\\bzoomIn\\b|\\bzoomOut\\b';
    var match = str.match(pattern);

    if (match) {
      return match[0];
    }

    return '';
  };

  var STAGE_HEIGHT = 100;
  var STAGE_WIDTH = 50;

  var getZoomInPoints = function getZoomInPoints() {
    var xCoords = [0, STAGE_WIDTH, STAGE_WIDTH, 0];
    var yCoords = [0, 0, STAGE_HEIGHT / 2, STAGE_HEIGHT / 2];
    return _.zip(xCoords, yCoords).map(function (coords) {
      return coords.join(',');
    }).join(' ');
  };

  var getZoomOutPoints = function getZoomOutPoints() {
    var xCoords = [0, STAGE_WIDTH, STAGE_WIDTH, 0];
    var yCoords = [STAGE_HEIGHT, STAGE_HEIGHT, STAGE_HEIGHT / 2, STAGE_HEIGHT / 2];
    return _.zip(xCoords, yCoords).map(function (coords) {
      return coords.join(',');
    }).join(' ');
  };
  /**
   * Zoom support to applicable cameras
   *  
   * @private
   * @class
   * @alias module:nmodule/videoDriver/rc/live/ZoomControl
   * @extends {module:nmodule/webEditors/rc/fe/BaseWidget}
   */


  var ZoomControl = /*#__PURE__*/function (_BaseWidget) {
    _inherits(ZoomControl, _BaseWidget);

    var _super = _createSuper(ZoomControl);

    function ZoomControl() {
      _classCallCheck(this, ZoomControl);

      return _super.apply(this, arguments);
    }

    _createClass(ZoomControl, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        dom.addClass('ZoomControl').html(tpl({
          height: STAGE_HEIGHT,
          width: STAGE_WIDTH
        }));
        this.$zoomCommands = this.$makeCommands();
        this.$init();
      }
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('ZoomControl');

        if (this.$ticket) {
          clearTimeout(this.$ticket);
        }
      }
    }, {
      key: "getZoomCommands",
      value: function getZoomCommands() {
        return this.$zoomCommands;
      }
    }, {
      key: "$init",
      value: function $init() {
        var rootSvgEl = this.$getRootSvgJq()[0];
        rootSvgEl.appendChild(this.$makeMediumRegion());
        rootSvgEl.appendChild(this.$makeSlowRegion());
        rootSvgEl.appendChild(this.$makeZoomInRegion());
        rootSvgEl.appendChild(this.$makeZoomOutRegion());
        this.$armHandlers();
      }
      /**
       * @private
       * @returns {JQuery}
       */

    }, {
      key: "$getRootSvgJq",
      value: function $getRootSvgJq() {
        return this.jq().find('svg');
      }
      /**
       * @private
       * @returns {number}
       */

    }, {
      key: "$getZoomInterval",
      value: function $getZoomInterval() {
        return this.properties().getValue('zoomInterval') || DEFAULT_ZOOM_INTERVAL;
      }
    }, {
      key: "$armHandlers",
      value: function $armHandlers() {
        var _this = this;

        var direction,
            speed,
            lastX,
            lastY,
            lastZoomedDirection,
            svg = this.$getRootSvgJq();

        var getPageX = function getPageX(e) {
          if (e.touches && e.touches.length > 0) {
            return e.touches[0].pageX;
          } else {
            return e.pageX || e.clientX + $(window).scrollLeft();
          }
        };

        var getPageY = function getPageY(e) {
          if (e.touches && e.touches.length > 0) {
            return e.touches[0].pageY;
          } else {
            return e.pageY || e.clientY + $(window).scrollTop();
          }
        };

        var getDirection = function getDirection(e) {
          var pageX = getPageX(e);
          var pageY = getPageY(e);

          if (!isFinite(pageX)) {
            pageX = lastX;
          }

          if (!isFinite(pageY)) {
            pageY = lastY;
          }

          return document.elementFromPoint(pageX, pageY);
        };

        var resetRegions = function resetRegions() {
          svg.find('polygon').toggleClass('zHighlight', false);
          $(direction).toggleClass('zEnd', true);
        };

        var reset = function reset() {
          // Always follow with a 'none' on mouseup
          _this.$zoom(_this.$getVideoZoomAction('none'))["catch"](logInfo);

          resetTicket();
          resetRegions(); // de-register the events

          svg.off(); // rebind start

          svg.on('mousedown touchstart', zoomStart);
        };

        var resetTicket = function resetTicket() {
          if (_this.$ticket) {
            clearTimeout(_this.$ticket);
          }
        };
        /**
         * Convenience to get the rectangle slow/medium region beneath the polygon
         * 
         * @param {Event} e 
         */


        var getSpeed = function getSpeed(e) {
          return getDirection(e);
        };

        var inFastZone = function inFastZone(e) {
          // When the mouse is dragged only beyond the top and bottom of the zoom region
          var pageY = getPageY(e);

          var _this$jq$offset = _this.jq().offset(),
              top = _this$jq$offset.top;

          return pageY < top || pageY > _this.jq().height() + top;
        };

        var zoom = function zoom() {
          if (lastZoomedDirection && lastZoomedDirection.nodeName === 'polygon') {
            var zoomAction = _this.$getZoomAction(speed.className.baseVal, getActionClass(lastZoomedDirection.className.baseVal));

            _this.$ticket = setTimeout(function () {
              return zoom();
            }, _this.$getZoomInterval());
            throttled(zoomAction);
          }
        };

        var zoomFast = function zoomFast() {
          if (lastZoomedDirection && lastZoomedDirection.nodeName === 'polygon') {
            var zoomAction = _this.$getZoomAction('fast', getActionClass(lastZoomedDirection.className.baseVal));

            _this.$ticket = setTimeout(function () {
              return zoomFast();
            }, _this.$getZoomInterval());
            throttled(zoomAction);
          }
        };

        var throttled = baja.throttle(function (zoomAction) {
          return _this.$zoom(zoomAction)["catch"](logInfo);
        }, {
          interval: 500,
          drop: true
        });

        var zoomStart = function zoomStart(e) {
          // Arm mousemove
          svg.on('mousemove touchmove', function (e) {
            direction = getDirection(e);

            if (direction && direction.nodeName === 'polygon') {
              lastZoomedDirection = direction;
              resetRegions();
              $(direction).toggleClass('zHighlight', true);
              $(direction).toggleClass('zEnd', false);
              var polygonDisplay = direction.style.display;
              direction.style.display = 'none';
              speed = getSpeed(e);
              direction.style.display = polygonDisplay;
              resetTicket();
              return direction && speed && zoom();
            } else {
              // A wandering touch event will get you here, just zoom fast in the last direction touched
              resetTicket();
              return zoomFast();
            }
          });
          $(document).off('mouseup touchend', reset);
          $(document).one('mouseup touchend', reset);
          svg.on('mouseleave', function (e) {
            resetTicket();

            if (inFastZone(e)) {
              lastZoomedDirection && zoomFast();
            } else {
              direction && speed && zoom();
            }
          });
          return false;
        };

        svg.on('mousedown touchstart', zoomStart);
      }
    }, {
      key: "$getZoomAction",
      value: function $getZoomAction(speed, direction) {
        var zoomAction = this.$getVideoZoomAction('none');

        switch (speed) {
          case 'slow':
            {
              switch (direction) {
                case 'zoomIn':
                  {
                    zoomAction = this.$getVideoZoomAction('zoomInSlow');
                    break;
                  }

                case 'zoomOut':
                  {
                    zoomAction = this.$getVideoZoomAction('zoomOutSlow');
                    break;
                  }
              }

              break;
            }

          case 'medium':
            {
              switch (direction) {
                case 'zoomIn':
                  {
                    zoomAction = this.$getVideoZoomAction('zoomInMedium');
                    break;
                  }

                case 'zoomOut':
                  {
                    zoomAction = this.$getVideoZoomAction('zoomOutMedium');
                    break;
                  }
              }

              break;
            }

          case 'fast':
            {
              switch (direction) {
                case 'zoomIn':
                  {
                    zoomAction = this.$getVideoZoomAction('zoomInFast');
                    break;
                  }

                case 'zoomOut':
                  {
                    zoomAction = this.$getVideoZoomAction('zoomOutFast');
                    break;
                  }
              }

              break;
            }
        }

        return zoomAction;
      }
    }, {
      key: "$getVideoZoomAction",
      value: function $getVideoZoomAction(actionTag) {
        return baja.$('videoDriver:VideoZoomEnum', actionTag);
      }
      /**
       * @private
       * @param {baja.FrozenEnum} zoomAction a 'videoDriver:VideoZoomEnum' enum
       * @returns {Promise}
       */

    }, {
      key: "$zoom",
      value: function $zoom(zoomAction) {
        if (!this.isEnabled()) {
          return Promise.resolve();
        }

        return this.$zoomCommands.get(zoomAction.getTag()).invoke();
      }
      /**
       * Make all the zoom commands
       * 
       * @private
       * @returns {baja.OrderedMap} map of zoom commands
       */

    }, {
      key: "$makeCommands",
      value: function $makeCommands() {
        var _this2 = this;

        var zoomRange = baja.$('videoDriver:VideoZoomEnum').getRange();
        var commandsMap = new baja.OrderedMap();
        zoomRange.getOrdinals().forEach(function (ordinal) {
          var zEnum = zoomRange.get(ordinal);
          var cmd = new Command({
            displayName: zEnum.getDisplayTag(),
            func: function func() {
              return zoom(_this2.value().getNavOrd(), zEnum.getTag());
            }
          });
          commandsMap.put(zEnum.getTag(ordinal), cmd);
        });
        return commandsMap;
      }
    }, {
      key: "$makeMediumRegion",
      value: function $makeMediumRegion() {
        var rect = document.createElementNS('http://www.w3.org/2000/svg', 'rect');
        rect.setAttribute('x', 0);
        rect.setAttribute('y', 0);
        rect.setAttribute('width', STAGE_WIDTH);
        rect.setAttribute('height', STAGE_HEIGHT);
        rect.setAttribute('class', 'medium');
        return rect;
      }
    }, {
      key: "$makeSlowRegion",
      value: function $makeSlowRegion() {
        var rect = document.createElementNS('http://www.w3.org/2000/svg', 'rect');
        var width = STAGE_WIDTH;
        var height = STAGE_HEIGHT * 0.65;
        rect.setAttribute('x', STAGE_WIDTH / 2 - width / 2);
        rect.setAttribute('y', STAGE_HEIGHT / 2 - height / 2);
        rect.setAttribute('width', width);
        rect.setAttribute('height', height);
        rect.setAttribute('class', 'slow');
        return rect;
      }
    }, {
      key: "$makeZoomOutRegion",
      value: function $makeZoomOutRegion() {
        var points = getZoomOutPoints();
        var polygon = document.createElementNS('http://www.w3.org/2000/svg', 'polygon');
        polygon.setAttribute('points', points);
        polygon.setAttribute('class', 'zoomOut');
        return polygon;
      }
    }, {
      key: "$makeZoomInRegion",
      value: function $makeZoomInRegion() {
        var points = getZoomInPoints();
        var polygon = document.createElementNS('http://www.w3.org/2000/svg', 'polygon');
        polygon.setAttribute('points', points);
        polygon.setAttribute('class', 'zoomIn');
        return polygon;
      }
    }]);

    return ZoomControl;
  }(BaseWidget);

  return ZoomControl;
});
