function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Cody Short
 */

/**
 * API Status: **Private**
 * @module nmodule/videoDriver/rc/live/VideoTimestampWidget
 */
define(['baja!', 'lex!videoDriver', 'bajaux/Widget', 'Promise', 'nmodule/videoDriver/rc/live/VideoFeedMixin', 'nmodule/webEditors/rc/wb/mixin/mixinUtils'], function (baja, lexs, Widget, Promise, VideoFeedMixin, mixinUtils) {
  'use strict';

  var hasMixin = mixinUtils.hasMixin;
  var TIMESTAMP_CHANGED_EVENT = VideoFeedMixin.TIMESTAMP_CHANGED_EVENT;
  /**
   * Support for displaying a video's current timestamp.
   *
   * @class
   * @alias nmodule/videoDriver/rc/live/VideoTimestampWidget
   * @extends {module:bajaux/Widget}
   */

  return /*#__PURE__*/function (_Widget) {
    _inherits(VideoTimestampWidget, _Widget);

    var _super = _createSuper(VideoTimestampWidget);

    function VideoTimestampWidget() {
      _classCallCheck(this, VideoTimestampWidget);

      return _super.apply(this, arguments);
    }

    _createClass(VideoTimestampWidget, [{
      key: "doInitialize",

      /**
       * @param {JQuery} dom
       */
      value: function doInitialize(dom) {
        dom.html('<div class="videoTimestampDisplay"></div>').addClass('VideoTimestampWidget');
        dom.find('.videoTimestampDisplay').hide();
      }
      /**
       * Arms event handler to show the video stream's current timestamp.
       * @param {module:nmodule/videoDriver/rc/live/VideoFeedMixin} videoStream a
       * `VideoStream` that has the `VideoFeedMixin`
       */

    }, {
      key: "doLoad",
      value: function doLoad(videoStream) {
        var _this = this;

        if (providesTimestamp(videoStream)) {
          var update = function update() {
            return _this.$updateTimestamp(videoStream.getVideoTimestamp());
          };

          this.$listener = update;
          videoStream.on(TIMESTAMP_CHANGED_EVENT, update);
          return update();
        }
      }
      /**
       * Updates the timestamp currently displayed.
       * @private
       * @param {number} timestamp
       * @returns {Promise}
       */

    }, {
      key: "$updateTimestamp",
      value: function $updateTimestamp(timestamp) {
        var timestampElement = this.$getTimestampElement();

        if (!timestamp) {
          timestampElement.hide();
          return Promise.resolve();
        }

        return baja.AbsTime.make({
          jsDate: new Date(timestamp)
        }).toString({
          showSeconds: true,
          showMilliseconds: true
        }).then(function (timeString) {
          timestampElement.show();
          timestampElement.text(timeString);
        });
      }
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('VideoTimestampWidget');
        var videoStream = this.value();

        if (providesTimestamp(videoStream)) {
          videoStream.removeListener(TIMESTAMP_CHANGED_EVENT, this.$listener);
        }
      }
      /**
       * @private
       * @returns {JQuery}
       */

    }, {
      key: "$getTimestampElement",
      value: function $getTimestampElement() {
        return this.jq().find('.videoTimestampDisplay');
      }
    }]);

    return VideoTimestampWidget;
  }(Widget);

  function providesTimestamp(obj) {
    return obj && hasMixin(obj, VideoFeedMixin.MIXIN_NAME) && typeof obj.getVideoTimestamp === 'function';
  }
});
