function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author JJ Frankovich
 */

/**
 * API Status: **Private**
 * @module nmodule/videoDriver/rc/live/VideoStatusWidget
 */
define(['lex!videoDriver', 'bajaux/Widget', 'nmodule/videoDriver/rc/live/VideoFeedMixin', 'nmodule/webEditors/rc/wb/mixin/mixinUtils'], function (lexs, Widget, VideoFeedMixin, mixinUtils) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
      videoDriverLex = _lexs[0];

  var hasMixin = mixinUtils.hasMixin;
  var CONNECTION_STATUS_CHANGED_EVENT = VideoFeedMixin.CONNECTION_STATUS_CHANGED_EVENT;
  var CONNECTING = videoDriverLex.get("connection.inProgress");
  var CONNECTED = videoDriverLex.get("connection.successful");
  /**
   * Support for displaying a video's current status.
   *
   * @class
   * @alias nmodule/videoDriver/rc/live/VideoStatusWidget
   * @extends {module:bajaux/Widget}
   */

  return /*#__PURE__*/function (_Widget) {
    _inherits(VideoStatusWidget, _Widget);

    var _super = _createSuper(VideoStatusWidget);

    function VideoStatusWidget() {
      _classCallCheck(this, VideoStatusWidget);

      return _super.apply(this, arguments);
    }

    _createClass(VideoStatusWidget, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        dom.html('<div class="videoStatusDisplay"></div>').addClass('VideoStatusWidget');
        dom.find('.videoStatusDisplay').hide();
      }
      /**
       * Arms event handler to show the video stream's current connection status.
       * @param {module:nmodule/videoDriver/rc/live/VideoFeedMixin} videoStream a
       * `VideoStream` that has the `VideoFeedMixin`
       */

    }, {
      key: "doLoad",
      value: function doLoad(videoStream) {
        var _this = this;

        if (providesConnectionStatus(videoStream)) {
          var update = function update() {
            return _this.$updateStatus(videoStream.getVideoConnectionStatus());
          };

          this.$listener = update;
          videoStream.on(CONNECTION_STATUS_CHANGED_EVENT, update);
          update();
        }
      }
      /**
       * Updates the status currently displayed.
       * @param {String} status
       */

    }, {
      key: "$updateStatus",
      value: function $updateStatus(status) {
        var elem = this.$getStatusElement();
        var previousText = elem.text();

        if (status) {
          elem.show();
        } else {
          elem.hide();
        }

        if (status !== previousText) {
          elem.text(String(status));
        }

        var loading = String(status).indexOf(CONNECTING) > -1;
        elem.toggleClass("loading", loading);
        elem.css('opacity', status === CONNECTED ? 0 : 0.75);
      }
      /**
       * @returns {JQuery}
       */

    }, {
      key: "$getStatusElement",
      value: function $getStatusElement() {
        return this.jq().find('.videoStatusDisplay');
      }
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('VideoStatusWidget');
        var videoStream = this.value();

        if (providesConnectionStatus(videoStream)) {
          videoStream.removeListener(CONNECTION_STATUS_CHANGED_EVENT, this.$listener);
        }
      }
    }]);

    return VideoStatusWidget;
  }(Widget);

  function providesConnectionStatus(obj) {
    return obj && hasMixin(obj, VideoFeedMixin.MIXIN_NAME) && typeof obj.getVideoConnectionStatus === 'function';
  }
});
