function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Vikram N 
 */

/**
 * API Status: **Private**
 * @module  module:nmodule/videoDriver/rc/live/PanTiltControl
 */
define(['baja!', 'baja!videoDriver:VideoPanTiltEnum', 'bajaux/commands/Command', 'nmodule/videoDriver/rc/rpc/rpc', 'nmodule/videoDriver/rc/live/PanTiltStage', 'nmodule/webEditors/rc/fe/BaseWidget'], function (baja, types, Command, rpc, PanTiltStage, BaseWidget) {
  'use strict';

  var move = rpc.move;

  var tpl = function tpl(_ref) {
    var width = _ref.width,
        height = _ref.height;
    return "\n    <svg class=\"panTiltStage\" xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 ".concat(width, " ").concat(height, "\" preserveAspectRatio=\"none\"></svg>\n  ");
  };
  /**
   * Pant and Tilt support to applicable cameras
   *  
   * @class
   * @alias module:nmodule/videoDriver/rc/live/PanTiltControl
   * @extends {module:nmodule/webEditors/rc/fe/BaseWidget}
   */


  var PanTiltControl = /*#__PURE__*/function (_BaseWidget) {
    _inherits(PanTiltControl, _BaseWidget);

    var _super = _createSuper(PanTiltControl);

    function PanTiltControl() {
      _classCallCheck(this, PanTiltControl);

      return _super.apply(this, arguments);
    }

    _createClass(PanTiltControl, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this = this;

        dom.addClass('PanTiltControl').html(tpl({
          height: PanTiltStage.STAGE_HEIGHT,
          width: PanTiltStage.STAGE_WIDTH
        }));
        this.panTiltCommands = this.$makeCommands();
        dom.on(PanTiltStage.MOVE_EVENT, function (e, moveAction) {
          return _this.$move(moveAction);
        }); // Make a the pan tilt svg stage

        var panTiltStage = this.panTiltStage = new PanTiltStage(this.jq());
        panTiltStage.setMoveInterval(this.properties().getValue('moveInterval'));
        panTiltStage.initStage();
      }
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('PanTiltControl');
      }
    }, {
      key: "doChanged",
      value: function doChanged(name, value) {
        if (name === 'moveInterval') {
          this.panTiltStage.setMoveInterval(value);
        }
      }
    }, {
      key: "getPanTiltCommands",
      value: function getPanTiltCommands() {
        return this.panTiltCommands;
      }
    }, {
      key: "$getSvgDOMElement",
      value: function $getSvgDOMElement() {
        return this.jq().find('.panTiltStage')[0];
      }
    }, {
      key: "$getMoveInterval",
      value: function $getMoveInterval() {
        return this.properties().getValue('moveInterval');
      }
      /**
       * Make all the pan-tilt commands
       * 
       * @private
       */

    }, {
      key: "$makeCommands",
      value: function $makeCommands() {
        var _this2 = this;

        var panTiltRange = baja.$('videoDriver:VideoPanTiltEnum').getRange();
        var commandsMap = new baja.OrderedMap();
        panTiltRange.getOrdinals().forEach(function (ordinal) {
          var ptEnum = panTiltRange.get(ordinal);
          var cmd = new Command({
            displayName: ptEnum.getDisplayTag(),
            func: function func() {
              if (!_this2.isEnabled()) {
                return;
              }

              return move(_this2.value().getNavOrd(), ptEnum.getTag());
            }
          });
          commandsMap.put(ptEnum.getTag(ordinal), cmd);
        });
        return commandsMap;
      }
      /**
       * @private
       * @param {baja.FrozenEnum} moveAction a 'videoDriver:VideoPanTiltEnum' enum
       * @returns {Promise}
       */

    }, {
      key: "$move",
      value: function $move(moveAction) {
        return this.panTiltCommands.get(moveAction.getTag()).invoke();
      }
    }]);

    return PanTiltControl;
  }(BaseWidget);

  return PanTiltControl;
});
