function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * Copyright 2019 Tridium, Inc. All Rights Reserved.
 */

/* eslint-env browser  */

/**
 * API Status: **Private**
 * @module  module:nmodule/videoDriver/rc/hls/HLSVideoStream
 */
define(['baja!', 'log!nmodule.videoDriver.rc.hls.HLSVideoStream', 'hls', 'jquery', 'Promise', 'underscore', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/videoDriver/rc/fe/playback/PlaybackMixin', 'nmodule/videoDriver/rc/fe/utils/videoDriverUtils', 'nmodule/videoDriver/rc/live/VideoFeedMixin', 'nmodule/videoDriver/rc/rpc/rpc', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/util/fileUtils', 'css!nmodule/videoDriver/rc/videoDriver'], function (baja, log, Hls, $, Promise, _, asyncUtils, PlaybackMixin, videoDriverUtils, VideoFeedMixin, rpc, BaseEditor, fileUtils) {
  "use strict";

  var startHlsStream = rpc.startHlsStream,
      stopHlsStream = rpc.stopHlsStream;
  var getPlaybackSpeedFactor = videoDriverUtils.getPlaybackSpeedFactor;
  var STREAM_DATA_RECEIVED_EVENT = VideoFeedMixin.STREAM_DATA_RECEIVED_EVENT,
      TIMESTAMP_CHANGED_EVENT = VideoFeedMixin.TIMESTAMP_CHANGED_EVENT;
  var logFine = log.fine.bind(log);
  var WIND_INTERVAL = 100; //Muted allows Chrome to autoplay and we don't do sound anyway
  //https://stackoverflow.com/questions/50607588/chrome-video-autoplay/51581844

  var tpl = function tpl() {
    return "  \n    <video autoplay muted class='videoInsert'></video>    \n  ";
  };
  /**
   * Baja Widget for LiveVideo via HLS and ffmpeg transcoding.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/videoDriver/rc/hls/HLSVideoStream
   * @implements module:module:nmodule/videoDriver/rc/fe/playback/PlaybackController
   * @mixes module:nmodule/videoDriver/rc/fe/playback/PlaybackMixin
   * @mixes module:nmodule/videoDriver/rc/live/VideoFeedMixin
   */


  return /*#__PURE__*/function (_BaseEditor) {
    _inherits(HLSVideoStream, _BaseEditor);

    var _super = _createSuper(HLSVideoStream);

    function HLSVideoStream(params) {
      var _this;

      _classCallCheck(this, HLSVideoStream);

      _this = _super.call(this, _.extend({
        keyName: 'HLSVideoStream',
        moduleName: 'videoDriver'
      }, params));
      PlaybackMixin(_assertThisInitialized(_this));
      VideoFeedMixin(_assertThisInitialized(_this));
      _this.$hls = null;
      return _this;
    }
    /**
     *
     * @param {JQuery} dom
     * @returns {Promise}
     */


    _createClass(HLSVideoStream, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        dom.html(tpl()).addClass('HLSVideoStream');
      }
      /**
       * @param {baja.Component} value a `nvideo:VideoCamera` instance
       * @returns {Promise}
       */

    }, {
      key: "doLoad",
      value: function doLoad(value) {
        var _this2 = this;

        if (value.isMounted()) {
          return this.$startStreaming(value.getNavOrd().toString()).then(function (_ref) {
            var streamUrl = _ref.streamUrl;

            var video = _this2.$getVideo();

            if (video.canPlayType('application/vnd.apple.mpegurl')) {
              video.src = streamUrl;
              video.addEventListener('canplay', function () {
                video.play();
              });
            } else if (Hls.isSupported()) {
              return _this2.waitForFile(streamUrl);
            } else {
              throw new Error("Browser does not support HLS stream:" + window.navigator.userAgent);
            }
          });
        }
      }
      /**
       * Wait for the the streaming file to be ready.
       * @param {String} streamUrl
       * @param {Number} counter
       * @return {Promise}
       */

    }, {
      key: "waitForFile",
      value: function waitForFile(streamUrl, counter) {
        var _this3 = this;

        if (!counter) {
          counter = 0;
        }

        var ord = streamUrl.replace("/file/", "file:^");
        return Promise.resolve(streamUrl.indexOf("/module/") === 0 || fileUtils.exists(ord)).then(function (exists) {
          if (exists) {
            _this3.doStream(streamUrl);
          } else {
            return asyncUtils.waitInterval(200).then(function () {
              counter++;
              return _this3.waitForFile(streamUrl, counter);
            });
          }
        });
      }
      /**
       * Play the stream 500ms afters its ready.
       *
       * @param {String} streamUrl
       */

    }, {
      key: "doStream",
      value: function doStream(streamUrl) {
        var _this4 = this;

        var video = this.$getVideo();
        var hls = this.$hls = new Hls();
        hls.loadSource(streamUrl);
        hls.attachMedia(video);
        hls.on(Hls.Events.MANIFEST_PARSED, function () {
          setTimeout(function () {
            if (!_this4.isDestroyed()) {
              video.play()["catch"](baja.error);
            }
          }, 500);
        });
      }
      /**
       * Notify the Video Camera to start streaming.
       *
       * @private
       * @param {baja.Ord} ord
       * @return {Promise.<{ streamUrl: string }>}
       */

    }, {
      key: "$startStreaming",
      value: function $startStreaming(ord) {
        return startHlsStream(ord);
      }
      /**
       * Stops hls and notifies the Video Camera to stop streaming too.
       *
       * @private
       * @param {baja.Ord} ord
       * @return {Promise|*}
       */

    }, {
      key: "$stopStreaming",
      value: function $stopStreaming(ord) {
        if (this.$hls && this.value()) {
          this.$hls.stopLoad();
          this.$hls = null;
          return stopHlsStream(ord);
        }
      }
      /**
       * @private
       * @returns {HTMLVideoElement}
       */

    }, {
      key: "$getVideo",
      value: function $getVideo() {
        return $('.videoInsert', this.jq())[0];
      }
      /**
       * @return {Promise|*}
       */

    }, {
      key: "doDestroy",
      value: function doDestroy() {
        var hls = this.$hls;

        if (hls) {
          hls.destroy();
        }

        this.jq().removeClass('HLSVideoStream');

        if (this.value()) {
          return this.$stopStreaming(this.value().getNavOrd());
        }
      }
      /**
       * @returns {number} current timestamp
       * @see module:nmodule/videoDriver/rc/live/VideoFeedMixin
       */

    }, {
      key: "getVideoTimestamp",
      value: function getVideoTimestamp() {
        //TODO: can HLS video files themselves be timestamped?
        return this.$currentTimestamp;
      }
      /**
       * @returns {boolean}
       * @see module:nmodule/videoDriver/rc/live/VideoFeedMixin
       */

    }, {
      key: "isVideoStreaming",
      value: function isVideoStreaming() {
        return !!this.$currentTimestamp;
      }
      /**
       * Called by videoDriverUtils. Emits `TIMESTAMP_CHANGED_EVENT` and `STREAM_DATA_RECEIVED_EVENT`.
       */

    }, {
      key: "timeUpdate",
      value: function timeUpdate() {
        this.$currentTimestamp = +new Date();
        this.emit(TIMESTAMP_CHANGED_EVENT);
        this.emit(STREAM_DATA_RECEIVED_EVENT);
      }
      /**
       * @returns {baja.Component} the currently loaded camera
       */

    }, {
      key: "getCamera",
      value: function getCamera() {
        return this.value();
      }
      /**
       * Change the current playback type and speed.
       * @param {object} params
       * @param {string} [params.type] a `BPlaybackTypeEnum` tag
       * @param {number} [params.speed] playback speed, from 1 to 10
       */

    }, {
      key: "doPlayback",
      value: function doPlayback(_ref2) {
        var type = _ref2.type,
            speed = _ref2.speed;
        clearTimeout(this.$ticket);
        logFine("HLSVideoStream#playback - type: ".concat(type, ", speed: ").concat(speed));
        var video = this.$getVideo();

        if (!video) {
          return;
        }

        switch (type) {
          case 'live':
          case 'play':
            return video.play();

          case 'pause':
            return video.pause();

          case 'slowRew':
          case 'fastRew':
          case 'slowFwd':
          case 'fastFwd':
            return this.$wind(getPlaybackSpeedFactor(type, speed || 1));
        }
      }
      /**
       * Start a rewind/fast-forward.
       * @private
       * @param {number} speedFactor
       */

    }, {
      key: "$wind",
      value: function $wind(speedFactor) {
        var _this5 = this;

        var video = this.$getVideo();

        if (!video) {
          return;
        }

        var secondsPerTick = WIND_INTERVAL / 1000 * speedFactor;
        var currentTime = video.currentTime || 0;
        var duration = video.duration || 0;
        video.pause();
        this.$ticket = setTimeout(function () {
          // if currentTime >= duration, video does not show the change
          video.currentTime = clamp(currentTime + secondsPerTick, 0, duration - 0.00001);

          _this5.$wind(speedFactor);
        }, WIND_INTERVAL);
      }
    }]);

    return HLSVideoStream;
  }(BaseEditor);

  function clamp(num, min, max) {
    return Math.min(Math.max(num, min), max);
  }
});
