function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/videoDriver/rc/fe/utils/HoldDownButton
 */
define(['log!nmodule.videoDriver.rc.fe.utils.HoldDownButton', 'bajaux/util/CommandButton', 'bajaux/Properties', 'jquery', 'Promise'], function (log, CommandButton, Properties, $, Promise) {
  'use strict';

  var logSevere = log.severe.bind(log);
  var DEFAULT_INTERVAL = 1000;
  /**
   * A CommandButton that will keep invoking the loaded Command on a set
   * interval for as long as the button is held down. It supports the following
   * bajaux `Properties`:
   *
   * - `released`: (function) a function to execute when the button is released
   * - `interval`: (number) how long, in millis, to wait between invocations
   *
   * @class
   * @alias module:nmodule/videoDriver/rc/fe/utils/HoldDownButton
   * @extends module:bajaux/util/CommandButton
   */

  return /*#__PURE__*/function (_CommandButton) {
    _inherits(HoldDownButton, _CommandButton);

    var _super = _createSuper(HoldDownButton);

    function HoldDownButton() {
      var _this;

      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      _classCallCheck(this, HoldDownButton);

      //TODO: remove this workaround after NCCB-40485 merges to default
      _this = _super.call(this, params.moduleName, params.keyName, params.formFactor);

      _this.properties().addAll(new Properties(params.properties));

      return _this;
    }
    /**
     * Arm event handlers to start and stop periodic invocation of the loaded
     * Command.
     *
     * @param {JQuery} dom
     * @returns {Promise}
     */


    _createClass(HoldDownButton, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this2 = this;

        return Promise.resolve(_get(_getPrototypeOf(HoldDownButton.prototype), "doInitialize", this).apply(this, arguments)).then(function () {
          dom.off(); // cancel out CommandButton click handler

          dom.on('mousedown', function () {
            return _this2.$press()["catch"](logSevere);
          });
        });
      }
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.$clearMouseupHandler();
        clearTimeout(this.$ticket);
        return _get(_getPrototypeOf(HoldDownButton.prototype), "doDestroy", this).apply(this, arguments);
      }
      /**
       * Invoke the command, and set a timeout to invoke it again after the
       * configured interval.
       *
       * @private
       * @returns {Promise}
       */

    }, {
      key: "$press",
      value: function $press() {
        var _this3 = this;

        this.$ticket = setTimeout(function () {
          return _this3.$press()["catch"](logSevere);
        }, this.$getInterval());
        this.$clearMouseupHandler();
        this.$armMouseupHandler();
        return this.value().invoke();
      }
      /**
       * Stop periodic invocations, and trigger the `released` callback if
       * present.
       *
       * @private
       * @returns {Promise|*}
       */

    }, {
      key: "$release",
      value: function $release() {
        if (this.$ticket) {
          clearTimeout(this.$ticket);
          var released = this.properties().getValue('released');
          return released && released();
        }
      }
      /**
       * @private
       */

    }, {
      key: "$armMouseupHandler",
      value: function $armMouseupHandler() {
        var _this4 = this;

        var mouseupHandler = this.$mouseupHandler = function () {
          Promise.resolve(_this4.$release())["catch"](logSevere);
        };

        $(document).one('mouseup', mouseupHandler);
      }
      /**
       * @private
       */

    }, {
      key: "$clearMouseupHandler",
      value: function $clearMouseupHandler() {
        var mouseupHandler = this.$mouseupHandler;

        if (mouseupHandler) {
          $(document).off('mouseup', mouseupHandler);
        }
      }
      /**
       * @private
       * @returns {number}
       */

    }, {
      key: "$getInterval",
      value: function $getInterval() {
        return this.properties().getValue('interval') || DEFAULT_INTERVAL;
      }
    }]);

    return HoldDownButton;
  }(CommandButton);
});
