function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/videoDriver/rc/fe/utils/FocusControlPane
 */
define(['lex!videoDriver', 'bajaux/Widget', 'bajaux/commands/Command', 'Promise', 'nmodule/videoDriver/rc/fe/utils/HoldDownButton', 'nmodule/videoDriver/rc/rpc/rpc', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/BaseWidget'], function (lexs, Widget, Command, Promise, HoldDownButton, rpc, fe, BaseWidget) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
      videoDriverLex = _lexs[0];

  var DEFAULT_FOCUS_INTERVAL = 1000;

  var tpl = function tpl(_ref) {
    var label = _ref.label;
    return "\n    <button type=\"button\" class=\"ux-btn-tb cameraControlUp\"></button>\n    <div class=\"label\">".concat(label, "</div>\n    <button type=\"button\" class=\"ux-btn-tb cameraControlDown\"></button>\n  ");
  };
  /**
   * This widget contains controls for performing iris and focus operations on
   * a video camera.
   *
   * @class
   * @alias module:nmodule/videoDriver/rc/fe/utils/FocusControlPane
   * @extends module:nmodule/webEditors/rc/fe/BaseWidget
   */


  return /*#__PURE__*/function (_BaseWidget) {
    _inherits(FocusControlPane, _BaseWidget);

    var _super = _createSuper(FocusControlPane);

    function FocusControlPane() {
      var _this;

      _classCallCheck(this, FocusControlPane);

      _this = _super.apply(this, arguments);

      _this.getCommandGroup().add(new Command({
        module: 'videoDriver',
        lex: 'commands.focus.in',
        func: function func() {
          return _this.$focus('focusInFast');
        }
      }), new Command({
        module: 'videoDriver',
        lex: 'commands.focus.out',
        func: function func() {
          return _this.$focus('focusOutFast');
        }
      }));

      return _this;
    }
    /**
     * Sets up command buttons for iris and focus controls.
     * @param {JQuery} dom
     * @returns {Promise}
     */


    _createClass(FocusControlPane, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this2 = this;

        dom.addClass('UpAndDownCameraControls').html(tpl({
          label: videoDriverLex.getSafe('Focus')
        }));
        var focusInterval = this.$getFocusInterval();
        return Promise.all([fe.buildFor({
          value: this.$getFocusInCommand(),
          dom: dom.find('.cameraControlUp'),
          type: HoldDownButton,
          formFactor: 'mini',
          properties: {
            interval: focusInterval,
            released: function released() {
              return _this2.$focus('none');
            }
          }
        }), fe.buildFor({
          value: this.$getFocusOutCommand(),
          dom: dom.find('.cameraControlDown'),
          type: HoldDownButton,
          formFactor: 'mini',
          properties: {
            interval: focusInterval,
            released: function released() {
              return _this2.$focus('none');
            }
          }
        })]);
      }
    }, {
      key: "doEnabled",
      value: function doEnabled(enabled) {
        this.$getFocusInCommand().setEnabled(enabled);
        this.$getFocusOutCommand().setEnabled(enabled);
      }
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('UpAndDownCameraControls');
        return this.getChildWidgets().destroyAll();
      }
    }, {
      key: "doChanged",
      value: function doChanged(name, value) {
        if (name === 'focusInterval') {
          this.$getFocusInButton().properties().setValue('interval', value);
          this.$getFocusOutButton().properties().setValue('interval', value);
        }
      }
      /**
       * @private
       * @param {string} tag a `videoDriver:VideoFocusEnum` tag
       * @returns {Promise}
       */

    }, {
      key: "$focus",
      value: function $focus(tag) {
        if (!this.isEnabled()) {
          return Promise.resolve();
        }

        return rpc.focus(this.value().getNavOrd(), tag);
      }
      /**
       * @private
       * @returns {module:nmodule/videoDriver/rc/fe/utils/HoldDownButton}
       */

    }, {
      key: "$getFocusInButton",
      value: function $getFocusInButton() {
        return Widget["in"](this.jq().find('.cameraControlUp'));
      }
      /**
       * @private
       * @returns {module:nmodule/videoDriver/rc/fe/utils/HoldDownButton}
       */

    }, {
      key: "$getFocusOutButton",
      value: function $getFocusOutButton() {
        return Widget["in"](this.jq().find('.cameraControlDown'));
      }
      /**
       * @private
       * @returns {module:bajaux/commands/Command}
       */

    }, {
      key: "$getFocusInCommand",
      value: function $getFocusInCommand() {
        return this.getCommandGroup().get(0);
      }
      /**
       * @private
       * @returns {module:bajaux/commands/Command}
       */

    }, {
      key: "$getFocusOutCommand",
      value: function $getFocusOutCommand() {
        return this.getCommandGroup().get(1);
      }
      /**
       * @private
       * @returns {number}
       */

    }, {
      key: "$getFocusInterval",
      value: function $getFocusInterval() {
        return this.properties().getValue('focusInterval') || DEFAULT_FOCUS_INTERVAL;
      }
    }]);

    return FocusControlPane;
  }(BaseWidget);
});
