function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Bhavani Patnam
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/videoDriver/rc/fe/utils/CameraPresetsWidget
 */
define(['baja!', 'jquery', 'lex!videoDriver', 'bajaux/Widget', 'dialogs', 'Promise', 'bajaux/events', 'bajaux/commands/Command', 'bajaux/util/CommandButton', 'nmodule/webEditors/rc/fe/BaseWidget', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'nmodule/webEditors/rc/fe/baja/DynamicEnumEditor', 'nmodule/webEditors/rc/util/htmlUtils', 'nmodule/videoDriver/rc/rpc/rpc', 'css!nmodule/videoDriver/rc/videoDriver'], function (baja, $, lexs, Widget, dialogs, Promise, events, Command, CommandButton, BaseWidget, fe, OrderedMapEditor, DynamicEnumEditor, htmlUtils, rpc) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
      lex = _lexs[0];

  var cameraPresetChooserLabel = lex.getSafe('VideoLiveView.CameraPresets.select.label');

  var tpl = function tpl() {
    return "\n    <span class=\"title\">".concat(cameraPresetChooserLabel, "</span>\n    <span class=\"ux-select dropdown\"></span>\n    <button type=\"button\" class=\"goCommand\"/>\n    <button type=\"button\" class=\"storeCommand\"></button>\n  ");
  };
  /**
   * CameraPresetsWidget view for the video playback feature to view on the UI
   *
   * API Status: **Private**
   * @class
   * @alias module:nmodule/videoDriver/rc/fe/utils/CameraPresetsWidgets
   * @extends module:nmodule/webEditors/rc/fe/BaseWidget
   * @param {Object} params
   */


  var CameraPresetsWidget = /*#__PURE__*/function (_BaseWidget) {
    _inherits(CameraPresetsWidget, _BaseWidget);

    var _super = _createSuper(CameraPresetsWidget);

    function CameraPresetsWidget() {
      _classCallCheck(this, CameraPresetsWidget);

      return _super.apply(this, arguments);
    }

    _createClass(CameraPresetsWidget, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this = this;

        dom.html(tpl()).addClass('CameraPresetsWidget');
        return Promise.all([fe.buildFor({
          formFactor: 'mini',
          type: CommandButton,
          dom: this.$getGoElement(),
          value: this.$getGoCommand()
        }), fe.buildFor({
          formFactor: 'mini',
          type: CommandButton,
          dom: this.$getStoreElement(),
          value: this.$getStoreCommand()
        })]).spread(function (goCommandButton, storeCommandButton) {
          _this.$goCommandButton = goCommandButton;
          _this.$storeCommandButton = storeCommandButton;
        });
      }
      /**
       * @param {baja.Component} value
       * @returns {Promise}
       */

    }, {
      key: "doLoad",
      value: function doLoad(value) {
        return this.$initializeView(value);
      }
      /**
       * Called by the Widget.setEnabled.
       * @param enabled
       * @returns {Promise}
       */

    }, {
      key: "doEnabled",
      value: function doEnabled(enabled) {
        if (enabled) {
          this.jq().show();
        } else {
          this.jq().hide();
        }

        return this.getChildWidgets().setAllEnabled(enabled);
      }
      /**
       * @private
       * @param {baja.Component} value
       * @returns {Promise}
       */

    }, {
      key: "$initializeView",
      value: function $initializeView(value) {
        var _this2 = this;

        return rpc.getCameraInfo(value.getNavOrd()).then(function (cameraInfo) {
          var presetTextEnum = baja.DynamicEnum.DEFAULT.decodeFromString(cameraInfo.presetEnum || '0');
          var validEnum = !presetTextEnum.equals(baja.DynamicEnum.DEFAULT);

          _this2.jq().toggle((cameraInfo.storePresetEnabled || cameraInfo.moveToPresetEnabled) && validEnum);

          _this2.$goCommandButton.jq().toggle(cameraInfo.moveToPresetEnabled && validEnum);

          _this2.$storeCommandButton.jq().toggle(cameraInfo.storePresetEnabled && validEnum);

          return fe.buildFor({
            dom: _this2.$getDropDown(),
            value: presetTextEnum,
            type: DynamicEnumEditor
          });
        });
      }
      /**
       * Display an error dialog, inserting the error text into the failure message.
       */

    }, {
      key: "$showErrorDialog",
      value: function $showErrorDialog(err) {
        dialogs.showOk({
          title: lex.getSafe('LiveView.invalidPreset.dialog.title'),
          content: lex.getSafe('LiveView.invalidPreset', err)
        });
      }
      /**
       * Destroys the editor and all children of the editor.
       * @returns {Promise}
       */

    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('CameraPresetsWidget');
        return Promise.all([this.getChildWidgets().destroyAll()]);
      }
    }, {
      key: "doChanged",

      /**
       * @param  {String} name The name of the Property that's changed.
       * @param  {*} value The new Property value.
       * @return {Promise}
       */
      value: function doChanged(name, value) {
        return Promise.resolve();
      }
      /**
       * @private
       * @returns {JQuery}
       */

    }, {
      key: "$getDropDown",
      value: function $getDropDown() {
        return this.jq().find('.dropdown');
      }
      /**
       * Returns the presets dropdown
       *
       * @private
       * @returns {module:bajaux/Widget}
       */

    }, {
      key: "$getDropDownWidget",
      value: function $getDropDownWidget() {
        return Widget["in"](this.$getDropDown());
      }
      /**
       * @private
       * @returns{JQuery}
       */

    }, {
      key: "$getGoElement",
      value: function $getGoElement() {
        return this.jq().find('.goCommand');
      }
      /**
       * @private
       * @returns{module:bajaux/Widget}
       */

    }, {
      key: "$getGoButton",
      value: function $getGoButton() {
        return Widget["in"](this.$getGoElement());
      }
      /**
       * @private
       * @returns{JQuery}
       */

    }, {
      key: "$getStoreElement",
      value: function $getStoreElement() {
        return this.jq().find('.storeCommand');
      }
      /**
       * @private
       * @returns{module:bajaux/Widget}
       */

    }, {
      key: "$getStoreButton",
      value: function $getStoreButton() {
        return Widget["in"](this.$getStoreElement());
      }
      /**
       * Function is used to get the value of Go Command from the CameraPresetsWidget
       *
       * @private
       * @returns{module:bajaux/commands/Command}
       */

    }, {
      key: "$getGoCommand",
      value: function $getGoCommand() {
        var that = this;

        if (!this.$goCommand) {
          this.$goCommand = new Command({
            module: 'videoDriver',
            lex: 'commands.mgr.go',
            func: function func() {
              return Promise.all([that.$getDropDownWidget().read()["catch"](function (err) {
                return that.$showErrorDialog(err);
              }), rpc.getCameraInfo(that.value().getNavOrd())]).then(function (_ref) {
                var _ref2 = _slicedToArray(_ref, 2),
                    actionArgument = _ref2[0],
                    cameraInfo = _ref2[1];

                that.value().invoke({
                  slot: cameraInfo.moveToPresetAction,
                  value: actionArgument
                });
              });
            }
          });
        }

        return this.$goCommand;
      }
      /**
       * Function is used to get the value of Store Command from the CameraPresetsWidget
       *
       * @private
       * @returns{module:bajaux/commands/Command}
       */

    }, {
      key: "$getStoreCommand",
      value: function $getStoreCommand() {
        var that = this;

        if (!this.$storeCommand) {
          this.$storeCommand = new Command({
            module: 'videoDriver',
            lex: 'commands.mgr.store',
            func: function func() {
              return Promise.all([that.$getDropDownWidget().read()["catch"](function (err) {
                return that.$showErrorDialog(err);
              }), rpc.getCameraInfo(that.value().getNavOrd())]).then(function (_ref3) {
                var _ref4 = _slicedToArray(_ref3, 2),
                    actionArgument = _ref4[0],
                    cameraInfo = _ref4[1];

                that.value().invoke({
                  slot: cameraInfo.storePresetAction,
                  value: actionArgument
                });
              });
            }
          });
        }

        return this.$storeCommand;
      }
    }]);

    return CameraPresetsWidget;
  }(BaseWidget);

  return CameraPresetsWidget;
});
