function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 *  Copyright 2020 Tridium, Inc. All Rights Reserved.
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/videoDriver/rc/fe/surveillance/WebSurveillanceViewer
 */
define(['baja!', 'bajaux/Widget', 'bajaux/mixin/subscriberMixIn', 'bajaux/events', 'jquery', 'Promise', 'bajaux/commands/Command', 'bajaux/util/SaveCommand', 'bajaux/util/CommandButton', 'nmodule/webEditors/rc/fe/BaseWidget', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/servlets/userData', 'nmodule/videoDriver/rc/fe/surveillance/DeviceListWidget', 'nmodule/videoDriver/rc/fe/surveillance/SurveillanceOptionsWidget', 'nmodule/videoDriver/rc/fe/surveillance/SurveillanceViewerGrid', 'lex!videoDriver', 'baja!videoDriver:VideoPlaybackMultistream'], function (baja, Widget, subscriberMixIn, events, $, Promise, Command, SaveCommand, CommandButton, BaseWidget, fe, userData, DeviceListWidget, SurveillanceOptionsWidget, SurveillanceViewerGrid, lexs, types) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
      lex = _lexs[0];

  var tpl = function tpl() {
    return "\n  <div class=\"WebSurveillanceViewerContainer\">\n    <div class=\"wrapperContainer leftContainerVisible\"> \n      <div class=\"leftContainer\"> \n        <div class=\"DeviceListWidget\"></div>\n        <div class=\"SurveillanceOptionsWidget\"></div>\n        <div class=\"SaveAndRefreshContainer\">\n          <button type=\"button\" class=\"saveButton\" />\n          <button type=\"button\" class=\"refreshButton\" /> \n        </div>\n      </div>\n      <div class=\"rightContainer\" />\n    </div>\n   </div>\n  ";
  };
  /**
   * Widget for surveillance of video from the camera. Provides surveillance view options like
   * viewing cameras in the station, changing values like frame rate, compression, resolution,
   * compression and layout.
   *
   * @private
   * @class
   * @extends module:nmodule/webEditors/rc/fe/BaseWidget
   * @alias module:nmodule/videoDriver/rc/fe/surveillance/WebSurveillanceViewer
   */


  return /*#__PURE__*/function (_BaseWidget) {
    _inherits(WebSurveillanceViewer, _BaseWidget);

    var _super = _createSuper(WebSurveillanceViewer);

    function WebSurveillanceViewer(params) {
      var _this;

      _classCallCheck(this, WebSurveillanceViewer);

      _this = _super.call(this, params);
      _this.$saveCommand = new SaveCommand();
      _this.$refreshCommand = new Command({
        module: 'videoDriver',
        lex: 'refreshCommand',
        func: function func() {
          return _this.$doRefresh();
        }
      });
      _this.$collapseCommand = new Command({
        module: 'videoDriver',
        lex: 'collapseCommand',
        func: function func() {
          return _this.$invokeToggle();
        }
      });

      _this.getCommandGroup().add(_this.$saveCommand, _this.$refreshCommand, _this.$collapseCommand);

      subscriberMixIn(_assertThisInitialized(_this));
      return _this;
    }
    /**
     * Initializes the dom.
     *
     * @param {jquery} dom
     * @returns {Promise}
     */


    _createClass(WebSurveillanceViewer, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this2 = this;

        dom.html(tpl()).addClass('WebSurveillanceViewer'); // Reload the grid only if the Options Widget is modified.

        dom.on(events.MODIFY_EVENT, '.SurveillanceOptionsWidget', function () {
          _this2.setModified(true);

          Promise.resolve(_this2.$reloadGrid())["catch"](baja.error);
          return false;
        }).on(events.MODIFY_EVENT, '.rightContainer', function () {
          // If the grid is changed via a drag drop, then just save.
          _this2.setModified(true);

          return false;
        });
        return Promise.all([fe.buildFor({
          formFactor: 'mini',
          type: CommandButton,
          dom: dom.find('.saveButton'),
          value: this.$saveCommand
        }), fe.buildFor({
          formFactor: 'mini',
          type: CommandButton,
          dom: dom.find('.refreshButton'),
          value: this.$refreshCommand
        })]);
      }
      /**
       * Loads the DeviceListWidget and SurveillanceOptionsWidget
       *
       * @param {baja.Component} value - the agent value on which WebSurveillanceViewer
       * is registered on.
       * @returns {Promise}
       */

    }, {
      key: "doLoad",
      value: function doLoad(value) {
        var _this3 = this;

        if (baja.hasType(value, 'videoDriver:VideoPlaybackMultistream')) {
          var promArray = [];
          promArray.push(fe.buildFor({
            formFactor: 'mini',
            type: DeviceListWidget,
            dom: this.$getCameraListElement(),
            value: value
          }), fe.buildFor({
            formFactor: 'mini',
            type: SurveillanceOptionsWidget,
            dom: this.$getSurveillanceOptionsElement(),
            value: value
          }));

          if (!this.value().getPermissions().hasAdminWrite()) {
            promArray.push(this.$saveCommand.setEnabled(false));
          }

          promArray.push(userData.get(this.$getProfileKey()).then(JSON.parse));
          return Promise.all(promArray).then(function (_ref) {
            var _ref2 = _slicedToArray(_ref, 3),
                cameraListContainer = _ref2[0],
                surveillanceOptionsWidget = _ref2[1],
                isLeftContainerVisible = _ref2[2];

            _this3.$cameraListContainer = cameraListContainer;
            _this3.$surveillanceOptionsWidget = surveillanceOptionsWidget;

            if (!isLeftContainerVisible) {
              _this3.$hideLeftContainer();
            }

            return _this3.$doLoadGridView(value);
          });
        } else {
          throw new Error('Invalid Type');
        }
      }
      /**
       * @private
       * @returns {string}
       */

    }, {
      key: "$getProfileKey",
      value: function $getProfileKey() {
        return 'survLeftContainerisVisible';
      }
      /**
       * @private
       * @returns {boolean}
       */

    }, {
      key: "$isLeftContainerVisible",
      value: function $isLeftContainerVisible() {
        return this.jq().find('.leftContainer').is(':visible');
      }
      /**
       * @private
       */

    }, {
      key: "$hideLeftContainer",
      value: function $hideLeftContainer() {
        this.jq().find('.wrapperContainer').toggleClass('leftContainerVisible', false);
        this.jq().find('.wrapperContainer').toggleClass('leftContainerHidden', true);
        this.$collapseCommand.setIcon(lex.get('restoreCommand.icon'));
        this.$collapseCommand.setDescriptionFormat(lex.get('restoreCommand.description'));
        this.$collapseCommand.setDisplayNameFormat(lex.get('restoreCommand.displayName'));
        this.jq().find('.leftContainer').animate({
          width: 'toggle'
        });
      }
      /**
       * @private
       */

    }, {
      key: "$showLeftContainer",
      value: function $showLeftContainer() {
        this.jq().find('.wrapperContainer').toggleClass('leftContainerHidden', false);
        this.jq().find('.wrapperContainer').toggleClass('leftContainerVisible', true);
        this.$collapseCommand.setIcon(lex.get('collapseCommand.icon'));
        this.$collapseCommand.setDescriptionFormat(lex.get('collapseCommand.description'));
        this.$collapseCommand.setDisplayNameFormat(lex.get('collapseCommand.displayName'));
        this.jq().find('.leftContainer').animate({
          width: 'toggle'
        });
      }
      /**
       * Invokes the toggle command action.
       *
       * @private
       */

    }, {
      key: "$invokeToggle",
      value: function $invokeToggle() {
        var isLeftContainerVisible = this.$isLeftContainerVisible();

        if (isLeftContainerVisible) {
          this.$hideLeftContainer();
        } else {
          this.$showLeftContainer();
        } // Reload the grid when there's a change in layout size.


        Promise.all([userData.put(this.$getProfileKey(), JSON.stringify(!isLeftContainerVisible)), this.$reloadGrid()])["catch"](baja.error);
      }
      /**
       * Reloads the surveillance viewer grid.
       *
       * @private
       * @returns {Promise}
       */

    }, {
      key: "$reloadGrid",
      value: function $reloadGrid() {
        var _this4 = this;

        return this.read().then(function (value) {
          return _this4.$doLoadGridView(value);
        });
      }
      /**
       * @private
       * @returns {Promise}
       */

    }, {
      key: "$doLoadGridView",
      value: function $doLoadGridView(value) {
        return fe.buildFor({
          formFactor: 'mini',
          type: SurveillanceViewerGrid,
          dom: this.$getSurveillanceGridElement(),
          value: value,
          properties: {
            layoutType: value.getLayout()
          }
        });
      }
      /**
       * Reads the surveillance options widget.
       *
       * @returns {Promise}
       */

    }, {
      key: "doRead",
      value: function doRead() {
        return this.$surveillanceOptionsWidget.read();
      }
      /**
       * Saves all child widgets
       *
       * @returns {Promise}
       */

    }, {
      key: "doSave",
      value: function doSave() {
        return this.getChildWidgets().saveAll();
      }
      /**
       * Destroys the editor and all children of the editor.
       * @returns {Promise}
       */

    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('WebSurveillanceViewer');
        return this.getChildWidgets().destroyAll();
      }
      /**
       * Layout the widgets in web surveillance Viewer
       * @returns {Promise}
       */

    }, {
      key: "doLayout",
      value: function doLayout() {
        return this.getChildWidgets().layoutAll();
      }
      /**
       * Using window.location to reload the page.
       *
       * @private
       * @returns {Promise}
       */

    }, {
      key: "$reload",
      value: function $reload() {
        return window.niagara.env.reload();
      }
      /**
       * Refreshes the page.
       *
       * @private
       * @returns {Promise}
       */

    }, {
      key: "$doRefresh",
      value: function $doRefresh() {
        return this.$reload();
      }
      /**
       * @private
       * @returns {jquery}
       */

    }, {
      key: "$getCameraListElement",
      value: function $getCameraListElement() {
        return this.jq().find('.DeviceListWidget');
      }
      /**
       * @private
       * @returns {module:nmodule/videoDriver/rc/fe/surveillance/DeviceListWidget}
       */

    }, {
      key: "$getDeviceListWidget",
      value: function $getDeviceListWidget() {
        return Widget["in"](this.$getCameraListElement());
      }
      /**
       * @private
       * @returns {jquery}
       */

    }, {
      key: "$getSurveillanceOptionsElement",
      value: function $getSurveillanceOptionsElement() {
        return this.jq().find('.SurveillanceOptionsWidget');
      }
      /**
       * @private
       * @returns {jquery}
       */

    }, {
      key: "$getSurveillanceGridElement",
      value: function $getSurveillanceGridElement() {
        return this.jq().find('.rightContainer');
      }
      /**
       * @private
       * @returns {jquery}
       */

    }, {
      key: "$getSurveillanceGridWidget",
      value: function $getSurveillanceGridWidget() {
        return Widget["in"](this.$getSurveillanceGridElement());
      }
      /**
       * @private
       * @returns {module:nmodule/videoDriver/rc/fe/surveillance/SurveillanceOptionsWidget}
       */

    }, {
      key: "$getSurveillanceOptionsWidget",
      value: function $getSurveillanceOptionsWidget() {
        return Widget["in"](this.$getSurveillanceOptionsElement());
      }
    }]);

    return WebSurveillanceViewer;
  }(BaseWidget);
});
