function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * Copyright 2020 Tridium, Inc. All Rights Reserved.
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/videoDriver/rc/fe/surveillance/SurveillanceOptionsWidget
 */
define(['baja!', 'bajaux/Widget', 'jquery', 'underscore', 'Promise', 'dialogs', 'bajaux/events', 'bajaux/mixin/subscriberMixIn', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/videoDriver/rc/fe/surveillance/surveillanceViewerEvents', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'bajaux/commands/Command', 'bajaux/util/SaveCommand', 'bajaux/util/CommandButton', 'lex!videoDriver', 'baja!videoDriver:VideoMultistreamAspectRatioEnum', 'baja!videoDriver:VideoFrameRateEnum', 'baja!videoDriver:VideoResolutionEnum', 'baja!videoDriver:VideoCompressionEnum', 'baja!videoDriver:VideoMultistreamLayoutTypesEnum', 'css!nmodule/videoDriver/rc/videoDriver'], function (baja, Widget, $, _, Promise, dialogs, events, subscriberMixIn, fe, BaseEditor, surveillanceViewerEvents, OrderedMapEditor, Command, SaveCommand, CommandButton, lexs) {
  'use strict';

  var ASPECT_RATIO_ENUM = baja.$('videoDriver:VideoMultistreamAspectRatioEnum');
  var FRAME_RATE_ENUM = baja.$('videoDriver:VideoFrameRateEnum');
  var RESOLUTION_ENUM = baja.$('videoDriver:VideoResolutionEnum');
  var COMPRESSION_ENUM = baja.$('videoDriver:VideoCompressionEnum');
  var LAYOUT_ENUM = baja.$('videoDriver:VideoMultistreamLayoutTypesEnum');

  var _lexs = _slicedToArray(lexs, 1),
      lex = _lexs[0];

  var tpl = function tpl() {
    return "<div class=\"SurveillanceOptionsContainer\"> \n                      <div class=\"feContainer\"> \n                        <span class=\"aspectRatioText\">".concat(lex.getSafe('VideoMultistreamViewer.ChooseAspectRatio'), "</span>\n                        <div class=\"aspectRatio\" />\n                        <span class=\"frameRateText\">").concat(lex.getSafe('VideoMultistreamViewer.ChooseFrameRate'), "</span>\n                        <div class=\"frameRate\"></div>\n                        <span class=\"resolutionText\">").concat(lex.getSafe('VideoMultistreamViewer.ChooseResolution'), "</span>\n                        <div class=\"resolution\"></div> \n                        <span class=\"compressionText\">").concat(lex.getSafe('VideoMultistreamViewer.ChooseCompression'), "</span>\n                        <div class=\"compression\"></div>\n                        <span class=\"layoutText\">").concat(lex.getSafe('VideoMultistreamViewer.ChooseLayout'), "</span>\n                        <div class=\"layout\"></div>\n                      </div>\n                     </div>");
  };
  /**
   * SurveillanceOptionsWidget will represent the configuration options for the SurveillanceViewer
   *
   * API Status: **Private**
   * @class
   * @alias module:nmodule/videoDriver/rc/fe/surveillance/SurveillanceOptionsWidget
   * @extends module:nmodule/webEditors/rc/fe/BaseWidget
   * @param {Object} params
   */


  var SurveillanceOptionsWidget = /*#__PURE__*/function (_BaseEditor) {
    _inherits(SurveillanceOptionsWidget, _BaseEditor);

    var _super = _createSuper(SurveillanceOptionsWidget);

    function SurveillanceOptionsWidget(params) {
      var _this;

      _classCallCheck(this, SurveillanceOptionsWidget);

      _this = _super.call(this, params);
      subscriberMixIn(_assertThisInitialized(_this));
      return _this;
    }
    /**
     * Initializes the widget
     *
     * @param {JQuery} dom
     * @returns {Promise}
     */


    _createClass(SurveillanceOptionsWidget, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        dom.html(tpl()).addClass('SurveillanceOptionsWidget');
      }
      /**
       * Reads the child widgets and applies those values on to a new copy of the value.
       * doRead invocation will happen out of the lifecycle methods from WebSurveillanceViewer,
       * we send a new changed copy back to validate with the current value.
       *
       * @returns {Promise}
       */

    }, {
      key: "doRead",
      value: function doRead() {
        var _this2 = this;

        return this.getChildWidgets().readAll().then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 5),
              aspectRatio = _ref2[0],
              frameRate = _ref2[1],
              resolution = _ref2[2],
              compression = _ref2[3],
              layout = _ref2[4];

          var newCopy = _this2.value().newCopy();

          var promArray = [];

          if (!_.isUndefined(aspectRatio)) {
            promArray.push(newCopy.set({
              slot: 'aspectRatio',
              value: aspectRatio
            }));
          }

          if (!_.isUndefined(frameRate)) {
            promArray.push(newCopy.set({
              slot: 'frameRate',
              value: frameRate
            }));
          }

          if (!_.isUndefined(resolution)) {
            promArray.push(newCopy.set({
              slot: 'resolution',
              value: resolution
            }));
          }

          if (!_.isUndefined(layout)) {
            promArray.push(newCopy.set({
              slot: 'layout',
              value: layout
            }));
          }

          if (!_.isUndefined(compression)) {
            promArray.push(newCopy.set({
              slot: 'compression',
              value: compression
            }));
          }

          return Promise.all(promArray).then(function () {
            return newCopy;
          });
        });
      }
      /**
       * Saves the widget
       *
       * @returns {Promise}
       */

    }, {
      key: "doSave",
      value: function doSave() {
        var _this3 = this;

        return Promise.all(this.getChildWidgets().map(function (child) {
          if (child.isModified()) {
            return child.read().then(function (modifiedChild) {
              var slotName;

              switch (modifiedChild.getType()) {
                case ASPECT_RATIO_ENUM.getType():
                  slotName = 'aspectRatio';
                  break;

                case FRAME_RATE_ENUM.getType():
                  slotName = 'frameRate';
                  break;

                case RESOLUTION_ENUM.getType():
                  slotName = 'resolution';
                  break;

                case COMPRESSION_ENUM.getType():
                  slotName = 'compression';
                  break;

                case LAYOUT_ENUM.getType():
                  slotName = 'layout';
                  break;
              }

              return _this3.value().set({
                slot: slotName,
                value: modifiedChild
              });
            });
          }
        }));
      }
      /**
       * Loads the widget
       *
       * @param {baja.Component} value
       * @returns {Promise}
       */

    }, {
      key: "doLoad",
      value: function doLoad(value) {
        var _this4 = this;

        if (baja.hasType(value, 'videoDriver:VideoPlaybackMultistream')) {
          var promArr = [];

          if (!value.getHideAspectRatio()) {
            promArr.push(fe.buildFor({
              formFactor: 'mini',
              type: ASPECT_RATIO_ENUM,
              dom: this.jq().find('.aspectRatio'),
              value: value.getAspectRatio()
            }));
          } else {
            this.jq().find('.aspectRatioText').hide();
            this.jq().find('.aspectRatio').hide();
          }

          if (!value.getHideFrameRate()) {
            promArr.push(fe.buildFor({
              formFactor: 'mini',
              type: FRAME_RATE_ENUM,
              dom: this.jq().find('.frameRate'),
              value: value.getFrameRate()
            }));
          } else {
            this.jq().find('.frameRateText').hide();
            this.jq().find('.frameRate').hide();
          }

          if (!value.getHideResolution()) {
            promArr.push(fe.buildFor({
              formFactor: 'mini',
              type: RESOLUTION_ENUM,
              dom: this.jq().find('.resolution'),
              value: value.getResolution()
            }));
          } else {
            this.jq().find('.resolutionText').hide();
            this.jq().find('.resolution').hide();
          }

          if (!value.getHideCompression()) {
            promArr.push(fe.buildFor({
              formFactor: 'mini',
              type: COMPRESSION_ENUM,
              dom: this.jq().find('.compression'),
              value: value.getCompression()
            }));
          } else {
            this.jq().find('.compressionText').hide();
            this.jq().find('.compression').hide();
          }

          if (!value.getHideLayout()) {
            promArr.push(fe.buildFor({
              formFactor: 'mini',
              type: OrderedMapEditor,
              dom: this.jq().find('.layout'),
              value: this.$getOrderedLayoutMap(),
              loadParams: {
                selectedValue: this.value().getLayout()
              },
              properties: {
                lexicon: 'videoDriver',
                lexiconIcons: true
              }
            }));
          } else {
            this.jq().find('.layoutText').hide();
            this.jq().find('.layout').hide();
          }

          return Promise.all(promArr).then(function () {
            return _this4.getChildWidgets().setAllEnabled(_this4.value().getPermissions().hasAdminWrite());
          });
        } else {
          throw new Error('Invalid type');
        }
      }
      /**
       * Returns the frameRate widget
       *
       * @private
       * @returns {module:bajaux/Widget}
       */

    }, {
      key: "$getFrameRateWidget",
      value: function $getFrameRateWidget() {
        return Widget["in"](this.jq().find('.frameRate'));
      }
      /**
       * Returns the aspectRatio widget
       *
       * @private
       * @returns {module:bajaux/Widget}
       */

    }, {
      key: "$getAspectRatioWidget",
      value: function $getAspectRatioWidget() {
        return Widget["in"](this.jq().find('.aspectRatio'));
      }
      /**
       * Returns the resolution widget
       *
       * @private
       * @returns {module:bajaux/Widget}
       */

    }, {
      key: "$getResolutionWidget",
      value: function $getResolutionWidget() {
        return Widget["in"](this.jq().find('.resolution'));
      }
      /**
       * Returns the compression widget
       *
       * @private
       * @returns {module:bajaux/Widget}
       */

    }, {
      key: "$getCompressionWidget",
      value: function $getCompressionWidget() {
        return Widget["in"](this.jq().find('.compression'));
      }
      /**
       * Returns the layout widget
       *
       * @private
       * @returns {module:bajaux/Widget}
       */

    }, {
      key: "$getLayoutWidget",
      value: function $getLayoutWidget() {
        return Widget["in"](this.jq().find('.layout'));
      }
      /**
       * Function gets the map of icons to be fetched from videoDriver module
       *
       * @private
       * @returns {baja.OrderedMap}
       */

    }, {
      key: "$getOrderedLayoutMap",
      value: function $getOrderedLayoutMap() {
        var map = new baja.OrderedMap();
        map.put('oneVideoPlayer', LAYOUT_ENUM.make(0));
        map.put('pictureInPictureLowerLeft', LAYOUT_ENUM.make(1));
        map.put('twoSmallOneLarge', LAYOUT_ENUM.make(2));
        map.put('grid2x2', LAYOUT_ENUM.make(3));
        map.put('grid3x3', LAYOUT_ENUM.make(4));
        return map;
      }
      /**
       * @returns {Promise}
       */

    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('SurveillanceOptionsWidget');
        return this.getChildWidgets().destroyAll();
      }
    }]);

    return SurveillanceOptionsWidget;
  }(BaseEditor);

  return SurveillanceOptionsWidget;
});
