function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * Copyright 2020 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/videoDriver/rc/fe/surveillance/DeviceListWidget
 */
define(['baja!', 'jquery', 'Promise', 'bajaux/mixin/subscriberMixIn', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'lex!videoDriver', 'nmodule/videoDriver/rc/rpc/rpc', 'underscore', 'css!nmodule/videoDriver/rc/videoDriver'], function (baja, $, Promise, subscriberMixIn, fe, BaseEditor, lexs, rpc, _) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
      lex = _lexs[0];

  var cameraListLabel = lex.getSafe('SurveillanceViewer.CameraList.Label');

  var tpl = function tpl() {
    return "<span class=\"title\">".concat(cameraListLabel, "</span>\n                     <div class=\"deviceList\"></div>");
  };
  /**
   * Trims the given ord down to only the slot part.
   * @param {string} ordString
   * @returns {string}
   */


  var trimToSlotPath = function trimToSlotPath(ordString) {
    return ordString === "null" ? "null" : /slot:\/(.)*/.exec(ordString)[0];
  };
  /**
   * DeviceListWidget will represent the camera list created for the SurveillanceViewer
   *
   * API Status: **Private**
   * @class
   * @alias module:nmodule/videoDriver/rc/fe/surveillance/DeviceListWidget
   * @extends module:nmodule/webEditors/rc/fe/BaseWidget
   */


  var DeviceListWidget = /*#__PURE__*/function (_BaseEditor) {
    _inherits(DeviceListWidget, _BaseEditor);

    var _super = _createSuper(DeviceListWidget);

    function DeviceListWidget() {
      _classCallCheck(this, DeviceListWidget);

      return _super.apply(this, arguments);
    }

    _createClass(DeviceListWidget, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        dom.html(tpl()).addClass('DeviceListWidget');
      }
    }, {
      key: "$getDeviceJq",
      value: function $getDeviceJq(value, index) {
        var deviceValue = _.escape(value);

        return "<div class=\"deviceBox box".concat(index, "\" title=\"").concat(deviceValue, "\" draggable=\"true\">\n                <img src=\"/module/videoDriver/icons/camera.png\" >\n                <span>").concat(deviceValue, "</span>\n              </div>");
      }
      /**
       * Creates the camerabox dom for each camera along with it's event listeners
       *
       * @private
       * @param {Array<Object>} deviceListObj
       * @param {JQuery} dom
       */

    }, {
      key: "$createDeviceListJq",
      value: function $createDeviceListJq(deviceListObj, dom) {
        var _this = this;

        var deviceListJq = dom.find('.deviceList');
        Object.keys(deviceListObj).forEach(function (key, index) {
          var deviceObjValue = deviceListObj[key];

          var deviceJq = _this.$getDeviceJq(deviceObjValue, index);

          deviceListJq.append(deviceJq);
          deviceListJq.find('.box' + index).on('dragstart', {
            value: 'station:|' + key
          }, function (event) {
            _this.$dragStartHandler(event);
          });
        });
      }
      /**
       * @private
       * @param {Event} event
       */

    }, {
      key: "$dragStartHandler",
      value: function $dragStartHandler(event) {
        event.originalEvent.dataTransfer.setData('text/plain', event.data.value);
      }
      /**
       * This method gets the list of added cameras in the station and excludes
       * the ones present in getExcludeCameras of Surveillance Viewer instance.
       *
       * This method can be overriden to provide custom devices.
       *
       * @returns {Promise}
       */

    }, {
      key: "getAddedDevices",
      value: function getAddedDevices(device) {
        var cameraListObj = {};
        var excludedCameraOrds = device.getExcludeCameras().getOrds().map(function (ord) {
          return trimToSlotPath(ord.toString());
        });
        return rpc.getAllCameras().then(function (deviceArray) {
          deviceArray.forEach(function (device) {
            var tokenDevice = device.split("|");
            var displayName = baja.SlotPath.unescape(tokenDevice[0]);
            var slotPath = baja.SlotPath.unescape(tokenDevice[1]);

            if (excludedCameraOrds.indexOf(slotPath) === -1) {
              cameraListObj[slotPath] = displayName;
            }
          });
          return cameraListObj;
        });
      }
      /**
       * Loads the value into the CameraList
       *
       * @param {baja.Component} value a `videoDriver:VideoPlaybackMultistream` instance
       * @returns {Promise}
       */

    }, {
      key: "doLoad",
      value: function doLoad(value) {
        if (!baja.hasType(value, "videoDriver:VideoPlaybackMultistream")) {
          throw new Error('CameraList must be loaded with videoDriver:VideoPlaybackMultistream');
        }

        return this.$doLoad(value);
      }
      /**
       * @private
       * @returns {Promise}
       */

    }, {
      key: "$doLoad",
      value: function $doLoad(device) {
        var _this2 = this;

        return this.getAddedDevices(device).then(function (deviceListObj) {
          _this2.$createDeviceListJq(deviceListObj, _this2.jq());
        });
      }
      /**
       *
       * @returns {Promise}
       */

    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('DeviceListWidget');
        return this.getChildWidgets().destroyAll();
      }
    }]);

    return DeviceListWidget;
  }(BaseEditor);

  return DeviceListWidget;
});
