function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Shivani Jakhmola
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/videoDriver/rc/fe/playback/WebVideoPlayback
 */
define(['baja!', 'bajaux/Properties', 'bajaux/Widget', 'bajaux/mixin/responsiveMixIn', 'bajaux/mixin/subscriberMixIn', 'Promise', 'underscore', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/webEditors/rc/fe/BaseWidget', 'nmodule/webEditors/rc/fe/baja/DisplayOnlyEditor', 'nmodule/webEditors/rc/fe/fe', 'nmodule/videoDriver/rc/fe/playback/PlaybackControlsWidget', 'nmodule/videoDriver/rc/fe/playback/CameraChooserWidget', 'nmodule/videoDriver/rc/fe/utils/videoDriverUtils', 'nmodule/videoDriver/rc/live/LiveVideo', 'nmodule/videoDriver/rc/live/stream/StreamSettingsCommand', 'baja!videoDriver:VideoPlaybackChooser,' + 'videoDriver:IVideoCamera'], function (baja, Properties, Widget, responsiveMixIn, subscriberMixIn, Promise, _, asyncUtils, BaseWidget, DisplayOnlyEditor, fe, PlaybackControlsWidget, CameraChooserWidget, videoDriverUtils, LiveVideo, StreamSettingsCommand) {
  'use strict';

  var tpl = function tpl() {
    return "\n    <div class=\"webVideoPlaybackContainer\">\n      <div class=\"CameraChooserWidget\"></div>\n      <div class=\"LiveVideo\"></div>\n      <div class=\"PlaybackControlsWidget\"></div>\n    </div>\n  ";
  };

  var extend = _.extend,
      isFunction = _.isFunction;
  var videoPlaybackChooserType = 'videoDriver:VideoPlaybackChooser';
  var videoCameraType = 'videoDriver:IVideoCamera';
  var PLAYBACK_TYPE = 'playbackType';
  var PLAYBACK_TIMESTAMP = 'playbackTimestamp';
  /**
   * Widget for playback of historical video from a camera. Provides playback
   * controls such as play/pause/rewind/seek.
   *
   * It supports the following bajaux Properties:
   *
   * - `playbackType`: a String corresponding to a `BPlaybackTypeEnum` tag.
   *   Specifies how the video should be playing. Defaults to `live`
   * - `playbackTimestamp`: a String encoding of a `baja:AbsTime` that indicates
   *   when the playback should start. Will only be respected if `playbackType`
   *   is `play`. Defaults to `AbsTime.DEFAULT`, which also indicates that
   *   the playback should start "now" instead of a specified time.
   *
   * @private
   * @class
   * @extends module:nmodule/webEditors/rc/fe/BaseWidget
   * @alias module:nmodule/videoDriver/rc/fe/WebVideoPlayback
   */

  return /*#__PURE__*/function (_BaseWidget) {
    _inherits(WebVideoPlayback, _BaseWidget);

    var _super = _createSuper(WebVideoPlayback);

    function WebVideoPlayback(params) {
      var _Properties$extend;

      var _this;

      _classCallCheck(this, WebVideoPlayback);

      _this = _super.call(this, extend({
        keyName: 'WebVideoPlayback',
        moduleName: 'videoDriver'
      }, params, {
        properties: Properties.extend((_Properties$extend = {}, _defineProperty(_Properties$extend, PLAYBACK_TYPE, {
          value: 'live',
          typeSpec: 'videoDriver:PlaybackTypeEnum'
        }), _defineProperty(_Properties$extend, PLAYBACK_TIMESTAMP, {
          value: baja.AbsTime.DEFAULT.encodeToString(),
          typeSpec: 'baja:AbsTime'
        }), _Properties$extend), params && params.properties)
      }));
      subscriberMixIn(_assertThisInitialized(_this));
      responsiveMixIn(_assertThisInitialized(_this), {
        'playback-thin': {
          maxWidth: 550
        }
      });

      _this.getCommandGroup().add(new StreamSettingsCommand(_assertThisInitialized(_this)));

      return _this;
    }
    /**
     * @private
     * @returns {module:nmodule/videoDriver/rc/live/stream/StreamSettingsCommand}
     */


    _createClass(WebVideoPlayback, [{
      key: "$getStreamSettingsCommand",
      value: function $getStreamSettingsCommand() {
        return this.getCommandGroup().get(0);
      }
      /**
       * @param {JQuery} dom
       */

    }, {
      key: "doInitialize",
      value: function doInitialize(dom) {
        dom.html(tpl()).addClass('WebVideoPlayback');
      }
      /**
       * @param {baja.Component} value - the agent value on which WebVideoPlayback
       * is registered on.
       * @returns {Promise}
       */

    }, {
      key: "doLoad",
      value: function doLoad(value) {
        var timestamp = videoDriverUtils.getNormalizedViewParams("playbackTimestamp");

        if (timestamp) {
          var startTime = baja.AbsTime.make({
            jsDate: new Date(parseInt(timestamp))
          }).encodeToString();
          this.properties().setValue('playbackTimestamp', startTime);
          this.properties().setValue('playbackType', 'play');
        }

        return this.$reload();
      }
      /**
       * Destroys the editor and all children of the editor.
       * @returns {Promise}
       */

    }, {
      key: "doDestroy",
      value: function doDestroy() {
        var jq = this.jq();
        jq.removeClass('WebVideoPlayback');
        jq.css('max-width', '');
        return this.getChildWidgets().destroyAll();
      }
      /**
       * Layout the widgets in playback Viewer
       * @returns {Promise}
       */

    }, {
      key: "doLayout",
      value: function doLayout() {
        return this.getChildWidgets().layoutAll();
      }
      /**
       * Destroy all the child widgets if necessary and reload the new child widgets.
       * @private
       * @return {Promise}
       */

    }, {
      key: "$reload",
      value: function $reload() {
        var _this2 = this;

        this.$reloading = true;
        return Promise.resolve(this.$loaded && this.getChildWidgets().destroyAll()).then(function () {
          if (_this2.$loaded) {
            _this2.doInitialize(_this2.jq());
          }

          _this2.$loaded = true;
          return _this2.$initializeView(_this2.value());
        })["finally"](function () {
          _this2.$reloading = false;
        });
      }
      /**
       * For a `VideoPlaybackChooser` value, resolve to the most recently used camera.
       * If the value is a camera, then resolve it.
       * Otherwise just resolve to undefined.
       * @private
       * @param {baja.Component} value
       * @return {Promise.<baja.Component|*>}
       */

    }, {
      key: "$resolveCamera",
      value: function $resolveCamera(value) {
        if (value.getType().is(videoPlaybackChooserType)) {
          var mostRecent = value.getMostRecentCameraViewed();

          if (mostRecent !== baja.Ord.DEFAULT) {
            return baja.Ord.make("station:|" + mostRecent).get().then(function (camera) {
              if (camera.getType().is(videoCameraType)) {
                return videoDriverUtils.resolveCamera(camera);
              }
            })["catch"](baja.error);
          }
        } else if (value.getType().is(videoCameraType)) {
          return videoDriverUtils.resolveCamera(value);
        }

        return Promise.resolve();
      }
      /**
       * Function is used to initialize the web video playback view with Camera Controls,
       * Video Display and Video Playback buttons
       * @private
       * @param {baja.Component} value - the agent value on which WebVideoPlayback
       * is registered on.
       * @returns {Promise}
       */

    }, {
      key: "$initializeView",
      value: function $initializeView(value) {
        var _this3 = this;

        return Promise.all([value.getType().is(videoPlaybackChooserType) && this.$buildCameraChooser(value), this.$resolveCamera(value).then(function (camera) {
          if (!camera) {
            return _this3.$showNoStreamError();
          }

          return _this3.$buildLiveVideo(camera).then(function (liveVideo) {
            var settingsCmd = _.result(liveVideo, '$getStreamSettingsCommand');

            _this3.$getStreamSettingsCommand().setEnabled(settingsCmd && settingsCmd.isEnabled());

            var videoStream = liveVideo.$getVideoStream();

            if (isFunction(videoStream.playback)) {
              return _this3.$buildPlaybackControls(videoStream);
            }
          });
        })]);
      }
      /**
        * @private
       * @param {baja.Component} camera
       * @returns {Promise.<module:nmodule/videoDriver/rc/fe/playback/CameraChooserWidget>}
       */

    }, {
      key: "$buildCameraChooser",
      value: function $buildCameraChooser(camera) {
        var _this4 = this;

        return fe.buildFor({
          formFactor: 'mini',
          type: CameraChooserWidget,
          dom: this.$getCameraChooserElement(),
          value: camera,
          properties: {
            onCameraChanged: function onCameraChanged() {
              if (!_this4.$reloading) {
                return _this4.$reload().then(function () {
                  return _this4.layout();
                });
              }
            }
          }
        });
      }
      /**
       * @private
       * @param {baja.Component} camera
       * @returns {Promise.<module:nmodule/videoDriver/rc/live/LiveVideo>}
       */

    }, {
      key: "$buildLiveVideo",
      value: function $buildLiveVideo(camera) {
        return fe.buildFor({
          formFactor: 'mini',
          type: LiveVideo,
          dom: this.$getLiveVideoElement(),
          value: camera,
          properties: this.properties().subset(['playbackType', 'playbackTimestamp', 'preferredResolution', 'preferredFrameRate', 'preferredCompression']).toValueMap()
        });
      }
      /**
       * @private
       * @param {module:nmodule/videoDriver/rc/fe/playback/PlaybackController} controller
       * @returns {Promise.<module:nmodule/videoDriver/rc/fe/playback/PlaybackControlsWidget>}
       */

    }, {
      key: "$buildPlaybackControls",
      value: function $buildPlaybackControls(controller) {
        return fe.buildFor({
          formFactor: 'mini',
          type: PlaybackControlsWidget,
          dom: this.$getVideoPlaybackControlsElement(),
          value: controller,
          properties: _defineProperty({}, PLAYBACK_TYPE, this.properties().getValue(PLAYBACK_TYPE))
        });
      }
      /**
       * @private
       * @returns {number} the timestamp the widget is user-configured to start
       * playback from
       */

    }, {
      key: "$getPlaybackTimestamp",
      value: function $getPlaybackTimestamp() {
        var str = this.properties().getValue(PLAYBACK_TIMESTAMP);

        if (str) {
          return baja.AbsTime.DEFAULT.decodeFromString(str).getMillis();
        }

        return 0;
      }
      /**
       * @private
       * @returns {JQuery}
       */

    }, {
      key: "$getVideoPlaybackControlsElement",
      value: function $getVideoPlaybackControlsElement() {
        return this.jq().find('.PlaybackControlsWidget');
      }
      /**
       * @private
       * @returns {module:nmodule/videoDriver/rc/fe/playback/PlaybackControlsWidget}
       */

    }, {
      key: "$getVideoPlaybackControlsWidget",
      value: function $getVideoPlaybackControlsWidget() {
        return Widget["in"](this.$getVideoPlaybackControlsElement());
      }
      /**
       * @private
       * @returns {JQuery}
       */

    }, {
      key: "$getLiveVideoElement",
      value: function $getLiveVideoElement() {
        return this.jq().find('.LiveVideo');
      }
      /**
       * @private
       * @returns {module:nmodule/videoDriver/rc/live/LiveVideo}
       */

    }, {
      key: "$getLiveVideo",
      value: function $getLiveVideo() {
        return Widget["in"](this.$getLiveVideoElement());
      }
      /**
       * @private
       * @returns {JQuery}
       */

    }, {
      key: "$getCameraChooserElement",
      value: function $getCameraChooserElement() {
        return this.jq().find('.CameraChooserWidget');
      }
      /**
       * @private
       * @returns {module:nmodule/videoDriver/rc/fe/playback/CameraChooserWidget}
       */

    }, {
      key: "$getCameraChooserWidget",
      value: function $getCameraChooserWidget() {
        return Widget["in"](this.$getCameraChooserElement());
      }
      /**
       * @private
       * @returns {module:bajaux/Widget}
       */

    }, {
      key: "$getVideoStream",
      value: function $getVideoStream() {
        return this.$getLiveVideo().$getVideoStream();
      }
      /**
       * @private
       * @returns {Promise}
       */

    }, {
      key: "$showNoStreamError",
      value: function $showNoStreamError() {
        return fe.buildFor({
          formFactor: 'mini',
          type: DisplayOnlyEditor,
          dom: this.$getLiveVideoElement(),
          value: videoDriverUtils.getNoStreamMessage()
        });
      }
    }]);

    return WebVideoPlayback;
  }(BaseWidget);
});
