function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Cody Short
 */

/**
 * API Status: **Private**
 * @module nmodule/videoDriver/rc/fe/playback/VideoEventChooser
 */
define(['baja!', 'lex!videoDriver', 'bajaux/Widget', 'bajaux/commands/Command', 'bajaux/util/CommandButton', 'jquery', 'Promise', 'nmodule/videoDriver/rc/rpc/rpc', 'nmodule/webEditors/rc/fe/BaseWidget', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/table/Table', 'nmodule/webEditors/rc/wb/table/model/TableModel', 'nmodule/webEditors/rc/wb/table/model/columns/JsonObjectPropertyColumn', 'nmodule/webEditors/rc/wb/table/model/Row', 'nmodule/webEditors/rc/util/ListSelection'], function (baja, lexs, Widget, Command, CommandButton, $, Promise, rpc, BaseWidget, fe, feDialogs, Table, TableModel, JsonObjectPropertyColumn, Row, ListSelection) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
      videoDriverLex = _lexs[0],
      sortTimeIndexRow = function sortTimeIndexRow(firstRow, secondRow) {
    var firstTime = firstRow.getSubject().timeIndex.valueOf(),
        secondTime = secondRow.getSubject().timeIndex.valueOf();

    if (firstTime > secondTime) {
      return 1;
    } else if (secondTime < firstTime) {
      return -1;
    } else {
      return 0;
    }
  },
      getLoadingMessage = function getLoadingMessage(leadingText) {
    return leadingText + " - " + videoDriverLex.getSafe('VideoEventChooser.LoadingEvents');
  };

  var CAMERA_ORD_PROPERTY = 'cameraOrd',
      EVENTS_PER_PAGE = 20;

  var tpl = function tpl(pageText) {
    return "\n    <div class=\"browseEventsContainer\">\n      <div class=\"browseEventsButtons\">\n        <span class=\"pageText\">".concat(pageText, "</span>\n        <button type=\"button\" class=\"ux-btn pageUpCommand\"/>\n        <button type=\"button\" class=\"ux-btn pageDownCommand\"/>\n        <button type=\"button\" class=\"ux-btn homePageCommand\"/>\n        <button type=\"button\" class=\"ux-btn findEventsCommand\" />   \n      </div>\n      <div class=\"videoEventChooserTableContainer\">\n        <table class='ux-table videoEventChooserTable'></table>\n        <div class=\"loadingMessage\">Test</div>\n      </div>\n    </div>\n  ");
  };
  /**
   * A widget for selecting video playback events based upon timestamp and description
   */


  var VideoEventChooser = /*#__PURE__*/function (_BaseWidget) {
    _inherits(VideoEventChooser, _BaseWidget);

    var _super = _createSuper(VideoEventChooser);

    function VideoEventChooser() {
      var _this;

      _classCallCheck(this, VideoEventChooser);

      _this = _super.apply(this, arguments);

      _this.validators().add(function (value) {
        if (!value) {
          var errorMsg = videoDriverLex.getSafe("VideoPlaybackView.BrowseEventsCommand.NoSelectionError");
          return Promise.reject(new Error(errorMsg));
        }
      });

      return _this;
    }
    /**
     * Initializes the dom with all elements.
     * @param {jQuery} dom
     * @returns {Promise}
     */


    _createClass(VideoEventChooser, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this2 = this;

        var pageText = videoDriverLex.getSafe("VideoEventChooser.Page");
        dom.html(tpl(pageText));
        return Promise.all([this.$buildCommands(dom), this.$buildEventChooserTable(dom)]).then(function () {
          _this2.$addDoubleClickRowEvent(dom);

          return _this2.$pageHome();
        });
      }
      /**
       * Adds the event handler for double click to notify quick select.
       */

    }, {
      key: "$addDoubleClickRowEvent",
      value: function $addDoubleClickRowEvent() {
        var _this3 = this;

        this.$getEventChooserTable().jq().on('dblclick', 'tr', function () {
          return _this3.read().then(function (value) {
            _this3.jq().trigger(BaseWidget.VALUE_READY_EVENT, [value]);
          });
        });
      }
      /**
       * Creates the command buttons that go in the top bar of the chooser.
       * @private
       * @param {jQuery} dom
       * @returns {Promise<Array.<module:bajaux/util/CommandButton>>}
       */

    }, {
      key: "$buildCommands",
      value: function $buildCommands(dom) {
        var _this4 = this;

        return Promise.all([fe.buildFor({
          type: CommandButton,
          dom: $('.pageUpCommand', dom),
          value: new Command({
            module: 'videoDriver',
            lex: 'VideoEventChooser.PageUp',
            func: function func() {
              return _this4.$pageUp();
            }
          })
        }), fe.buildFor({
          type: CommandButton,
          dom: $('.pageDownCommand', dom),
          value: new Command({
            module: 'videoDriver',
            lex: 'VideoEventChooser.PageDown',
            func: function func() {
              return _this4.$pageDown();
            }
          })
        }), fe.buildFor({
          type: CommandButton,
          dom: $('.homePageCommand', dom),
          value: new Command({
            module: 'videoDriver',
            lex: 'VideoEventChooser.PageHome',
            func: function func() {
              return _this4.$pageHome();
            }
          })
        }), fe.buildFor({
          type: CommandButton,
          dom: $('.findEventsCommand', dom),
          value: new Command({
            module: 'videoDriver',
            lex: 'VideoEventChooser.SeekMore',
            func: function func() {
              return _this4.$findEvents();
            }
          })
        })]);
      }
      /**
       * Creates the table element that the events will be displayed in.
       * @private
       * @param {jQuery} dom
       * @returns {Promise}
       */

    }, {
      key: "$buildEventChooserTable",
      value: function $buildEventChooserTable(dom) {
        var _this5 = this;

        var rows = [],
            selection = new ListSelection();
        selection.setExclusiveFilter(function () {
          return true;
        });
        selection.on('changed', function () {
          _this5.setModified(true);
        });
        return fe.buildFor({
          dom: $(".videoEventChooserTable", dom),
          type: Table,
          value: this.$buildTableModel(rows),
          selection: selection
        });
      }
      /**
       * Fetches the data from the RPC and loads it into the table.
       * @private
       * @param {baja.AbsTime} timeIndex
       * @param {number} fetchVector
       * @param {string} loadingMessage
       * @returns {Promise}
       */

    }, {
      key: "$fetchDataIntoTable",
      value: function $fetchDataIntoTable(timeIndex, fetchVector, loadingMessage) {
        var _this6 = this;

        var loadingMessageElement = this.jq().find(".loadingMessage");
        loadingMessageElement.text(loadingMessage);
        loadingMessageElement.show();
        var cameraOrd = this.properties().getValue(CAMERA_ORD_PROPERTY);
        return rpc.getCameraPlaybackEvents(cameraOrd, timeIndex, fetchVector).then(function (cameraArray) {
          var rows = [];

          for (var i = 0; i < cameraArray.length; i++) {
            rows.push(new Row(cameraArray[i]));
          }

          return _this6.$updateTableRows(rows);
        }).then(function () {
          loadingMessageElement.hide();
        })["catch"](function (error) {
          loadingMessageElement.show();
          var displayedMessage = videoDriverLex.getSafe("VideoEventChooser.LoadingEventsError", [error.message]);
          loadingMessageElement.text(displayedMessage);
        });
      }
      /**
       * Reads the time value of the selected element in the table.
       * @returns {null|baja.AbsTime} the time selected
       */

    }, {
      key: "doRead",
      value: function doRead() {
        var selectedRows = this.$getEventChooserTable().getSelectedRows();

        if (selectedRows.length > 0) {
          return selectedRows[0].getSubject()["timeIndex"];
        }

        return null;
      }
    }, {
      key: "doLoad",
      value: function doLoad(value) {}
      /**
       * Updates the table data to display the events after the most recent event
       * in the table including that event.
       * @private
       * @returns {Promise}
       */

    }, {
      key: "$pageUp",
      value: function $pageUp() {
        var rows = this.$getEventChooserTable().getModel().getRows(),
            pageUpMessage = videoDriverLex.getSafe('VideoEventChooser.PageUp.label'),
            loadingMessage = getLoadingMessage(pageUpMessage);
        rows.sort(sortTimeIndexRow);
        var time = rows.length > 0 ? rows[0].getSubject().timeIndex : baja.AbsTime.now();
        return this.$fetchDataIntoTable(time, EVENTS_PER_PAGE, loadingMessage);
      }
      /**
       * Updates the table data to display the events before the least recent event
       * in the table including that event.
       * @private
       * @returns {Promise}
       */

    }, {
      key: "$pageDown",
      value: function $pageDown() {
        var rows = this.$getEventChooserTable().getModel().getRows(),
            pageDownMessage = videoDriverLex.getSafe('VideoEventChooser.PageDown.label'),
            loadingMessage = getLoadingMessage(pageDownMessage);
        rows.sort(sortTimeIndexRow);
        var time = rows.length > 0 ? rows[rows.length - 1].getSubject().timeIndex : baja.AbsTime.now();
        return this.$fetchDataIntoTable(time, -EVENTS_PER_PAGE, loadingMessage);
      }
      /**
       * Updates the table data to display the home page
       * @private
       * @returns {Promise}
       */

    }, {
      key: "$pageHome",
      value: function $pageHome() {
        var pageHomeMessage = videoDriverLex.getSafe('VideoEventChooser.PageHome.label'),
            loadingMessage = getLoadingMessage(pageHomeMessage);
        return this.$fetchDataIntoTable(baja.AbsTime.now(), EVENTS_PER_PAGE, loadingMessage);
      }
      /**
       * Opens the find events dialog for selecting an AbsTime
       * @private
       * @returns {Promise}
       */

    }, {
      key: "$findEvents",
      value: function $findEvents() {
        var _this7 = this;

        return feDialogs.showFor({
          title: videoDriverLex.get('VideoPlaybackView.PlayFromTimeIndex.title'),
          value: baja.AbsTime.now(),
          formFactor: 'mini'
        }).then(function (eventsStartingAt) {
          if (eventsStartingAt) {
            var findEventsText = videoDriverLex.getSafe('VideoEventChooser.SeekMore.label'),
                loadingMessage = getLoadingMessage(findEventsText);
            return _this7.$fetchDataIntoTable(eventsStartingAt, EVENTS_PER_PAGE, loadingMessage);
          }
        });
      }
      /**
       * Using the given rows, build a new table model for the data with the
       * rows sorted in descending order.
       * @private
       * @param {Array.<module:nmodule/webEditors/rc/wb/table/model/Row>} rows
       * @returns {module:nmodule/webEditors/rc/wb/table/model/TableModel}
       */

    }, {
      key: "$buildTableModel",
      value: function $buildTableModel(rows) {
        var timeIndexColumn = new JsonObjectPropertyColumn('timeIndex', {
          displayName: videoDriverLex.getSafe('EventChooserTable.Header.TimeIndex')
        }),
            descriptionColumn = new JsonObjectPropertyColumn('description', {
          displayName: videoDriverLex.getSafe('EventChooserTable.Header.MsgText')
        }),
            columns = [timeIndexColumn, descriptionColumn];

        timeIndexColumn.buildCell = function (row, dom) {
          var time = this.getValueFor(row);
          return time.toString({
            showSeconds: true,
            showMilliseconds: true
          }).then(function (datetimeString) {
            dom.text(datetimeString);
          });
        };

        timeIndexColumn.setSortable(false);
        descriptionColumn.setSortable(false);
        rows.sort(sortTimeIndexRow);
        rows.reverse();
        return new TableModel({
          rows: rows,
          columns: columns
        });
      }
      /**
       * Replaces the data in the table with the given rows.
       * @private
       * @param {module:nmodule/webEditors/rc/wb/table/model/Row} rows
       * @returns {Promise}
       */

    }, {
      key: "$updateTableRows",
      value: function $updateTableRows(rows) {
        return this.$getEventChooserTable().load(this.$buildTableModel(rows));
      }
      /**
       * @private
       * @returns {module:bajaux/util/CommandButton}
       */

    }, {
      key: "$getPageUpCommandButton",
      value: function $getPageUpCommandButton() {
        return Widget["in"](this.jq().find('.pageUpCommand'));
      }
      /**
       * @private
       * @returns {module:bajaux/util/CommandButton}
       */

    }, {
      key: "$getPageDownCommandButton",
      value: function $getPageDownCommandButton() {
        return Widget["in"](this.jq().find('.pageDownCommand'));
      }
      /**
       * @private
       * @returns {module:bajaux/util/CommandButton}
       */

    }, {
      key: "$getHomePageCommandButton",
      value: function $getHomePageCommandButton() {
        return Widget["in"](this.jq().find('.homePageCommand'));
      }
      /**
       * @private
       * @returns {module:bajaux/util/CommandButton}
       */

    }, {
      key: "$getFindEventsCommandButton",
      value: function $getFindEventsCommandButton() {
        return Widget["in"](this.jq().find('.findEventsCommand'));
      }
      /**
       * @returns {module:baja/coll/Table}
       */

    }, {
      key: "$getEventChooserTable",
      value: function $getEventChooserTable() {
        return Widget["in"](this.jq().find('.videoEventChooserTable'));
      }
    }]);

    return VideoEventChooser;
  }(BaseWidget);

  return VideoEventChooser;
});
