function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Divya D
 */

/* eslint-env browser */

/**
 * Widget for selecting a camera from a dropdown.
 * API Status: **Private**
 * @module nmodule/videoDriver/rc/fe/playback/CameraChooserWidget
 */
define(['baja!', 'jquery', 'lex!videoDriver', 'bajaux/Widget', 'dialogs', 'Promise', 'bajaux/events', 'bajaux/commands/Command', 'nmodule/webEditors/rc/fe/BaseWidget', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'nmodule/videoDriver/rc/rpc/rpc', 'underscore', 'css!nmodule/videoDriver/rc/videoDriver'], function (baja, $, lex, Widget, dialogs, Promise, events, Command, BaseWidget, fe, OrderedMapEditor, rpc, _) {
  'use strict';

  var _lex = _slicedToArray(lex, 1),
      videoDriverslex = _lex[0];

  var cameraChooserLabel = videoDriverslex.getSafe('VideoPlaybackView.CameraChooser.label'),
      cameraChooserDefaultSelection = _.unescape(videoDriverslex.getSafe("VideoPlaybackChooserView.ChooseCameraBox.ChooseCamera")),
      MODIFY_EVENT = events.MODIFY_EVENT;

  var tpl = function tpl() {
    return "\n    <span class=\"title\">".concat(cameraChooserLabel, "</span>\n    <span class=\"ux-select dropdown\"></span>\n  ");
  };
  /**
   * Trims the given ord down to only the slot part.
   * @param {string} ordString
   * @returns {string}
   */


  var trimToSlotPath = function trimToSlotPath(ordString) {
    return ordString === "null" ? "null" : /slot:\/(.)*/.exec(ordString)[0];
  };
  /**
   * Generates a display name with the ord included.
   * @param {string} displayName
   * @param {string} ord
   * @returns {string}
   */


  var getDisplayNameWithOrd = function getDisplayNameWithOrd(displayName, ord) {
    return "".concat(displayName, " (").concat(ord, ")");
  };

  var CameraChooserWidget = /*#__PURE__*/function (_BaseWidget) {
    _inherits(CameraChooserWidget, _BaseWidget);

    var _super = _createSuper(CameraChooserWidget);

    /**
     *
     * @param {Object} [params]
     * @param {CameraChooserWidget~onCameraChanged} [params.properties.onCameraChanged]
     */
    function CameraChooserWidget(params) {
      var _this;

      _classCallCheck(this, CameraChooserWidget);

      _this = _super.apply(this, arguments);
      _this.$getCameraArray = _.once(rpc.getAllCameras);
      return _this;
    }
    /**
     * Called when the camera selection changes.
     * @callback CameraChooserWidget~onCameraChanged
     * @param {string} selectedOrd
     */

    /**
     * Sets up the dom for the camera chooser and registers events.
     * @param dom
     * @returns {Promise}
     */


    _createClass(CameraChooserWidget, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this2 = this;

        dom.html(tpl()).addClass('CameraChooserWidget');
        return this.$getLengthPatternMap().then(function (patternMap) {
          return fe.buildFor({
            dom: _this2.$getDropDown(),
            value: patternMap,
            loadParams: {
              selectedValue: "0"
            },
            type: OrderedMapEditor
          });
        }).then(function () {
          _this2.$getDropDown().on(MODIFY_EVENT, function (event, dropdownWidget) {
            var selectedValue = dropdownWidget.getSelectedValue();
            return Promise.resolve(_this2.value().setMostRecentCameraViewed(baja.Ord.make(selectedValue))).then(function () {
              var cameraChanged = _this2.properties().getValue('onCameraChanged');

              if (cameraChanged) {
                cameraChanged(selectedValue);
              }
            });
          });
        });
      }
      /**
       * Loads the value into the CameraChooser
       *
       * @param {baja.Component} value a `videoDriver:VideoPlaybackChooser` instance
       */

    }, {
      key: "doLoad",
      value: function doLoad(value) {
        var _this3 = this;

        if (!baja.hasType(value, "videoDriver:VideoPlaybackChooser")) {
          return Promise.reject(new Error('CameraChooser must be loaded with videoDriver:VideoPlaybackChooser'));
        }

        var mostRecentCameraOrdString = trimToSlotPath(value.getMostRecentCameraViewed().toString());
        this.$excludedCameraOrds = _.map(value.getExcludeCameras().getOrds(), function (ord) {
          return trimToSlotPath(ord.toString());
        });
        return this.$getLengthPatternMap(mostRecentCameraOrdString).then(function (cameraMap) {
          return _this3.$getDropDownWidget().load(cameraMap, {
            selectedValue: mostRecentCameraOrdString
          });
        });
      }
      /**
       * Loads the ord string specified into the dropdown selection.
       * @private
       * @param {string} ordString
       */

    }, {
      key: "$loadOrdIntoDropdown",
      value: function $loadOrdIntoDropdown(ordString) {
        var dropDownWidget = this.$getDropDownWidget();
        var trimmedOrd = trimToSlotPath(ordString);
        dropDownWidget.setSelectedValue(trimmedOrd);
      }
      /**
       * Destroys the editor and all children of the editor.
       * @returns {Promise}
       */

    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('CameraChooserWidget');
        return Promise.all([this.getChildWidgets().destroyAll()]);
      }
    }, {
      key: "doChanged",

      /**
       * @param  {String} name The name of the Property that's changed.
       * @param  {*} value The new Property value.
       * @return {Promise}
       */
      value: function doChanged(name, value) {
        return Promise.resolve();
      }
      /**
       * Gets the jquery element of the dropdown.
       * @private
       * @returns {JQuery}
       */

    }, {
      key: "$getDropDown",
      value: function $getDropDown() {
        return this.jq().find('.dropdown');
      }
      /**
       * Gets the widget of the dropdown
       * @private
       * @returns {module:nmodule/webEditors/rc/fe/baja/OrderedMapEditor}
       */

    }, {
      key: "$getDropDownWidget",
      value: function $getDropDownWidget() {
        return Widget["in"](this.$getDropDown());
      }
      /**
       * This method builds an ordered map for camera keys/values and returns it.
       * Adds a default value to map based upon selectedCameraOrd.
       * @private
       * @param {string} [selectedCameraOrd]
       * @returns {Promise.<module:baja/sys/structures/OrderedMap>}
       */

    }, {
      key: "$getLengthPatternMap",
      value: function $getLengthPatternMap(selectedCameraOrd) {
        var _this4 = this;

        var trimmedCameraOrd = selectedCameraOrd && trimToSlotPath(selectedCameraOrd);
        var map = new baja.OrderedMap();
        return this.$getCameraArray().then(function (cameraArray) {
          map.put(cameraChooserDefaultSelection, baja.Ord.DEFAULT.toString());
          var i,
              isSelectedOrdInList = false,
              duplicateDisplayNames = [];

          for (i = 0; i < cameraArray.length; i++) {
            var split = cameraArray[i].split("|");
            var displayName = baja.SlotPath.unescape(split[0]);
            var slotPath = baja.SlotPath.unescape(split[1]);

            if (!_.contains(_this4.$excludedCameraOrds, slotPath)) {
              var isDisplayNameDuplicate = map.contains(displayName) || duplicateDisplayNames.contains(displayName);

              if (isDisplayNameDuplicate) {
                var originalDisplayName = displayName;
                duplicateDisplayNames.push(originalDisplayName);
                var existingMapValue = map.get(originalDisplayName);

                if (existingMapValue) {
                  map.rename(originalDisplayName, getDisplayNameWithOrd(originalDisplayName, existingMapValue));
                }

                displayName = getDisplayNameWithOrd(displayName, slotPath);
              }

              map.put(displayName, slotPath);

              if (slotPath === trimmedCameraOrd) {
                isSelectedOrdInList = true;
              }
            }
          }

          if (trimmedCameraOrd && trimmedCameraOrd !== baja.Ord.DEFAULT.toString() && isSelectedOrdInList) {
            map.remove(cameraChooserDefaultSelection);
          }

          return map;
        });
      }
    }]);

    return CameraChooserWidget;
  }(BaseWidget);

  return CameraChooserWidget;
});
