function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Cody Short
 */

/* eslint-env browser  */

/**
 * API Status: **Private**
 * @module  module:nmodule/videoDriver/rc/alarm/VideoCameraChooser
 */
define(['baja!', 'nmodule/webEditors/rc/wb/links/OrdChooser', 'nmodule/webEditors/rc/wb/tree/BajaComplexTreeNode', 'lex!videoDriver', 'baja!videoDriver:IVideoCamera', 'baja!baja:Component'], function (baja, OrdChooser, BajaComplexTreeNode, lexs) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
      videoDriverLex = _lexs[0];
  /**
   * An editor for selecting a videoDriver:IVideoSource.
   * @class
   * @alias module:nmodule/videoDriver/rc/alarm/VideoCameraChooser
   * @extends module:nmodule/webEditors/rc/wb/links/OrdChooser
   */


  var VideoCameraChooser = function VideoCameraChooser() {
    OrdChooser.apply(this, arguments);
    this.properties().add("rootNode", "station:|slot:/Drivers");
    this.properties().add("displayFilter", function (parent, child) {
      return child instanceof BajaComplexTreeNode && baja.hasType(child.value(), 'baja:Component');
    });
    this.properties().add("selectFilter", function (selected) {
      if (selected !== baja.Ord.DEFAULT) {
        return selected.get().then(function (value) {
          if (!value.getType().is('videoDriver:IVideoCamera')) {
            throw new Error(videoDriverLex.getSafe("VideoCameraChooser.invalidSelection"));
          }
        });
      }
    });
  };

  VideoCameraChooser.prototype = Object.create(OrdChooser.prototype);
  VideoCameraChooser.prototype.constructor = VideoCameraChooser;
  return VideoCameraChooser;
});
