/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Aaron Laniewicz
 */

/**
 * API Status: **Private**
 * @since Niagara 4.3
 * @module nmodule/control/rc/fe/ManualTriggerModeEditor
 */
define([
  'baja!',
  'nmodule/webEditors/rc/fe/baja/DisplayOnlyEditor'
], function (
  baja,
  DisplayOnlyEditor
) {

  'use strict';

  /**
   * Field editor for working with `control:ManualTriggerMode` instances.
   *
   * @class
   * @alias module:nmodule/control/rc/fe/ManualTriggerModeEditor
   * @extends module:nmodule/webEditors/rc/fe/CompositeEditor
   */
  var ManualTriggerModeEditor = function () {
    DisplayOnlyEditor.apply(this, arguments);
  };
  ManualTriggerModeEditor.prototype = Object.create(DisplayOnlyEditor.prototype);
  ManualTriggerModeEditor.prototype.constructor = ManualTriggerModeEditor;


  /**
   * Initialize the `ManualTriggerModeEditor`.
   *
   * @param {jQuery} dom
   * @returns {Promise}
   */
  ManualTriggerModeEditor.prototype.doInitialize = function (dom) {
    dom.html('<label class="manualLabel"></label>');
  };

  /**
   * Load the `ManualTriggerMode`.
   *
   * @param {module:nmodule/control/rc/baja/ManualTriggerMode} manualTriggerMode
   * @returns {Promise}
   */
  ManualTriggerModeEditor.prototype.doLoad = function (manualTriggerMode) {
    this.$getManualElement().text(String(manualTriggerMode));
  };

  ManualTriggerModeEditor.prototype.$getManualElement = function () {
    return this.jq().find('.manualLabel');
  };

  return ManualTriggerModeEditor;
});
