/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Private**
 * @module nmodule/alarm/rc/fe/AlarmPrioritiesEditor
 */
define(['baja!',
  'jquery',
  'nmodule/alarm/rc/baja/AlarmPriorities',
  'nmodule/webEditors/rc/fe/CompositeEditor',
  'nmodule/webEditors/rc/fe/config/CompositeBuilder',
  'css!nmodule/alarm/rc/fe/alarmEditors'], function (baja,
                                                     $,
                                                     AlarmPriorities,
                                                     CompositeEditor,
                                                     CompositeBuilder) {

  'use strict';

  //TODO: i18n
  var KEYS = ['toOffnormal', 'toFault', 'toNormal', 'toAlert'];

  /**
   * Editor for handling `alarm:AlarmPriorities` values.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/CompositeEditor
   * @alias module:nmodule/alarm/rc/fe/AlarmPrioritiesEditor
   */
  var AlarmPrioritiesEditor = function AlarmPrioritiesEditor() {
    var that = this;

    CompositeEditor.apply(that, arguments);
  };
  AlarmPrioritiesEditor.prototype = Object.create(CompositeEditor.prototype);
  AlarmPrioritiesEditor.prototype.constructor = AlarmPrioritiesEditor;

  /**
   * The builder for an `AlarmPrioritiesEditor` will create numeric editors
   * for the four fields of an `alarm:AlarmPriorities` value.
   *
   * @returns {module:nmodule/webEditors/rc/fe/config/CompositeBuilder}
   */
  AlarmPrioritiesEditor.prototype.makeBuilder = function () {
    var that    = this,
        builder = new CompositeBuilder();

    builder.getConfigFor = function (key) {
      return {
        formFactor: 'mini',
        properties: {
          max: AlarmPriorities.MAX_PRIORITY,
          min: AlarmPriorities.MIN_PRIORITY,
          prelabel: key,
          precision: 0
        }
      };
    };

    builder.getDomFor = function () {
      return $('<span/>').appendTo(that.jq());
    };

    builder.getKeys = function () {
      return KEYS.slice();
    };

    builder.getValueFor = function (key) {
      var ap = this.getDataSource();
      switch (key) {
        case 'toOffnormal':
          return ap.getToOffnormal();
        case 'toFault':
          return ap.getToFault();
        case 'toNormal':
          return ap.getToNormal();
        case 'toAlert':
          return ap.getToAlert();
      }
    };

    return builder;
  };

  /**
   * Read all numeric editors and construct an `alarm:AlarmPriorities` instance.
   *
   * @returns {Promise}
   */
  AlarmPrioritiesEditor.prototype.doRead = function () {
    return this.getBuilder().readAll().spread(AlarmPriorities.make);
  };

  return AlarmPrioritiesEditor;
});
