/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Private**
 * @module nmodule/alarm/rc/db/commands/RefreshCommand
 */
define(['lex!alarm', 'bajaux/commands/Command'],
  function (lexs, Command) {

    "use strict";

    var RefreshCommand = function (params) {
      Command.call(this, params);
    };

    RefreshCommand.prototype = Object.create(Command.prototype);
    RefreshCommand.prototype.constructor = RefreshCommand;


    RefreshCommand.makeFor = function (view) {
      var lex = lexs[0];
      return new RefreshCommand({
        displayName: lex.get('command.refresh.label'),
        description: lex.get('command.refresh.label'),
        icon: lex.get('command.refresh.icon'),
        func: function () {
          if (view.pager) {
            view.pager.update();
          }
        }
      });
    };

    return RefreshCommand;

  });
