/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Private**
 * @module nmodule/alarm/rc/db/AlarmPropertyColumn
 */
define([
  'baja!',
  'jquery',
  'Promise',
  'nmodule/alarm/rc/console/baja/BajaDataChannel',
  'nmodule/alarm/rc/util/alarmUtils',
  'nmodule/webEditors/rc/wb/table/model/columns/PropertyColumn' ], function (
    baja,
    $,
    Promise,
    BajaDataChannel,
    alarmUtils,
    PropertyColumn) {

  "use strict";

  /**
   * @class
   * @alias module:nmodule/alarm/rc/db/AlarmPropertyColumn
   * @extends module:nmodule/webEditors/rc/wb/table/model/columns/PropertyColumn
   */
  var AlarmPropertyColumn = function () {
    PropertyColumn.apply(this, arguments);
  };
  AlarmPropertyColumn.prototype = Object.create(PropertyColumn.prototype);
  AlarmPropertyColumn.prototype.constructor = AlarmPropertyColumn;

  /**
   * Customize the column value for each row
   * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
   * @param {JQuery} dom
   */
  AlarmPropertyColumn.prototype.buildCell = function (row, dom) {
    return Promise.resolve(this.$rowToString(row))
      .then(function (str) { dom.text(str); });
  };

  /**
   * @private
   * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
   * @returns {Promise.<String>|String}
   */
  AlarmPropertyColumn.prototype.$rowToString = function (row) {
    var alarmRecord = row.getSubject(),
      value = this.getValueFor(row);

    switch (this.getName()) {
      case 'sourceState':
      case 'ackState':
      case 'alarmTransition':
        return alarmUtils.getAlarmDataDisplayName(String(value));

      case 'source':
        var sourceFormatPattern = alarmRecord.get('alarmData').get('sourceName');
        if (sourceFormatPattern) {
          return baja.Format.format({ pattern: sourceFormatPattern });
        }
        break;

      case 'timestamp':
      case 'normalTime':
      case 'ackTime':
      case 'lastUpdate':
        var tz = (alarmRecord.alarmData && alarmRecord.alarmData.TimeZone) || baja.TimeZone.UTC;
        return BajaDataChannel.createDateString(value.getMillis(), tz);
    }

    return String(value);
  };

  return AlarmPropertyColumn;
});
