/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Jeremy Narron
 */

/**
 * API Status: **Private**
 * @module nmodule/alarm/rc/console/table/columns/SelectColumn
 */
define([
  "Promise",
  "nmodule/webEditors/rc/wb/table/model/Column"], function (
  Promise,
  Column
) {
  "use strict";

  /**
   * A column used to select rows.
   *
   * @class
   * @extends {module:nmodule/webEditors/rc/wb/table/model/Column}
   * @alias {module:nmodule/alarm/rc/console/table/columns/SelectColumn}
   */
  var SelectColumn = function () {
    Column.call(this, "select");
    this.setHidable(false);
    this.setExportable(false);
  };

  SelectColumn.prototype = Object.create(Column.prototype);
  SelectColumn.prototype.constructor = SelectColumn;

  SelectColumn.prototype.toDisplayName = function () {
    // Do this explictly so it doesn't fallback from
    // the display name to the name.
    return Promise.resolve("");
  };

  SelectColumn.prototype.buildCell = function (row, dom) {
    return Promise.resolve(dom.html("<input type='checkbox'/>"));
  };

  return SelectColumn;
});
