/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Jeremy Narron
 */

/**
 * API Status: **Private**
 * @module nmodule/alarm/rc/console/table/columns/CustomAlarmDataColumn
 */
define([
  'lex!alarm',
  'nmodule/alarm/rc/console/table/columns/DefaultColumn',
  'nmodule/webEditors/rc/util/textUtils'
], function (
  lexs,
  DefaultColumn,
  textUtils
) {
  'use strict';

  var lex = lexs[0];

  /**
   * CustomAlarmDataColumn
   *
   * @class
   * @extends {module:nmodule/alarm/rc/console/table/columns/DefaultColumn}
   * @alias {module:nmodule/alarm/rc/console/table/columns/CustomAlarmDataColumn}
   * @param {String} name the column name
   */
  var CustomAlarmDataColumn = function (name) {
    DefaultColumn.apply(this, [name, {
      displayName: lex.get({
        key: 'alarm.console.columns.' + name,
        def: textUtils.toFriendly(name)
      })
    }]);
  };
  CustomAlarmDataColumn.prototype = Object.create(DefaultColumn.prototype);
  CustomAlarmDataColumn.prototype.constructor = CustomAlarmDataColumn;

  /**
   * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
   * @returns {String}
   */
  CustomAlarmDataColumn.prototype.getValueFor = function (row) {
    var subject = row.getSubject(),
        alarmData = subject && subject._alarmData;
    return alarmData && alarmData[this.getName()] || '';
  };

  return CustomAlarmDataColumn;
});
