/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Jeremy Narron
 */

/**
 * API Status: **Private**
 * @module nmodule/alarm/rc/console/table/columns/AlarmDataColumn
 */
define([
  'lex!alarm',
  'underscore',
  'nmodule/alarm/rc/console/table/columns/DefaultColumn',
  'nmodule/webEditors/rc/util/textUtils'
], function (
  lexs,
  _,
  DefaultColumn,
  textUtils
) {
  'use strict';

  var lex = lexs[0];

  /**
   * AlarmDataColumn
   *
   * @class
   * @extends {module:nmodule/alarm/rc/console/table/columns/DefaultColumn}
   * @alias {module:nmodule/alarm/rc/console/table/columns/AlarmDataColumn}
   */
  var AlarmDataColumn = function () {
    DefaultColumn.apply(this, ['alarmData', {
      displayName: lex.get({
        key: 'alarm.console.columns.alarmData',
        def: textUtils.toFriendly('alarmData')
      })
    }]);
  };
  AlarmDataColumn.prototype = Object.create(DefaultColumn.prototype);
  AlarmDataColumn.prototype.constructor = AlarmDataColumn;

  /**
   * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
   * @returns {String}
   */
  AlarmDataColumn.prototype.getValueFor = function (row) {
    var data = _.map(row.getSubject().alarmData, function (value, key) {
      return key + '=' + value;
    });
    data.sort(function (str1, str2) {
      return str1.toLowerCase().localeCompare(str2.toLowerCase());
    });
    return data.join(',');
  };

  return AlarmDataColumn;
});
