/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Jeremy Narron
 */

/**
 * API Status: **Private**
 * @module nmodule/alarm/rc/console/table/columns/AckStateColumn
 */
define([
  'lex!alarm',
  'nmodule/alarm/rc/console/table/columns/DefaultColumn',
  'nmodule/webEditors/rc/util/textUtils'
], function (
  lexs,
  DefaultColumn,
  textUtils
) {
  'use strict';

  var lex = lexs[0];

  /**
   * AckStateColumn
   *
   * @class
   * @extends {module:nmodule/alarm/rc/console/table/columns/DefaultColumn}
   * @alias {module:nmodule/alarm/rc/console/table/columns/AckStateColumn}
   */
  var AckStateColumn = function () {
    DefaultColumn.apply(this, ['ackState', {
      displayName: lex.get({
        key: 'alarm.console.columns.ackState',
        def: textUtils.toFriendly('ackState')
      })
    }]);
  };
  AckStateColumn.prototype = Object.create(DefaultColumn.prototype);
  AckStateColumn.prototype.constructor = AckStateColumn;

  /**
   * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
   * @returns {Number|String}
   */
  AckStateColumn.prototype.getValueFor = function (row) {
    var subject = row.getSubject(),
        acked = subject.ackedCount,
        unacked = subject.unackedCount,
        ackPending = subject.ackPendingCount;

    if (typeof acked === 'number') {
      return ackPending ?
        lex.get('alarm.console.ackState.withPending', acked, unacked, ackPending) :
        lex.get('alarm.console.ackState.withoutPending', acked, unacked);
    }

    return row.getSubject().ackState;
  };

  return AckStateColumn;
});
