/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Private**
 * @module nmodule/alarm/rc/console/commands/ShowAlarmsCommand
 */
define([
  'lex!alarm',
  'Promise',
  'underscore',
  'dialogs',
  'bajaux/commands/Command',
  'nmodule/alarm/rc/console/commands/alarmConsoleCommandMixIn'
], function (lexs,
             Promise,
             _,
             dialogs,
             Command,
             alarmConsoleCommandMixIn) {
  'use strict';

  var lex                 = lexs[0],
      SHOW_RECURRING_NAME = lex.get('alarm.console.commands.showRecurring.displayName'),
      SHOW_RECURRING_DESC = lex.get('alarm.console.commands.showRecurring.description'),
      SHOW_ALL_NAME       = lex.get('alarm.console.commands.showAll.displayName'),
      SHOW_ALL_DESC       = lex.get('alarm.console.commands.showAll.description');

  function getSelectedSources(view) {
    var table      = view.$getAlarmTable(),
      subjects = _.invoke(table.getSelectedRows(), 'getSubject');
    return _.pluck(subjects, 'source');
  }

  /**
   * Command that goes between the multi and single source alarm views in the alarm console.
   *
   * @constructor
   * @param {module:nmodule/alarm/rc/console/AlarmConsole} view The alarm console view.
   * @extends {module:bajaux/commands/Command}
   * @mixes {module:nmodule/alarm/rc/console/commands/alarmConsoleCommandMixIn}
   */
  var ShowAlarmsCommand = function (view) {
    var that      = this,
        viewModel = view.$getViewModel(),
        ss        = view.isSingleSourceView();

    Command.apply(this, [{
      module: 'alarm',
      lex: ss ? 'alarm.console.commands.showAll' : 'alarm.console.commands.showRecurring',
      func: function () {
        ss = !ss;
        that.setEnabled(ss);
        that.setDisplayNameFormat(ss ? SHOW_ALL_NAME : SHOW_RECURRING_NAME);
        that.setDescriptionFormat(ss ? SHOW_ALL_DESC : SHOW_RECURRING_DESC);
        if (!ss) {
          that.setIcon(lex.get('alarm.console.columns.icon.alarm'));
        }
        return Promise.resolve(dialogs.showLoading(0,
          viewModel.loadAlarmSummary(ss && {sources: getSelectedSources(view)})
            .then(function () {
              return viewModel.reloadAlarmTableColumns();
            })
            .then(function () {
              view.$initSortColumn();
            })));
      }
    }]);

    alarmConsoleCommandMixIn(that);

    that.$showInCommandBar = true;
    that.$view = view;
  };

  ShowAlarmsCommand.prototype = Object.create(Command.prototype);
  ShowAlarmsCommand.prototype.constructor = ShowAlarmsCommand;

  ShowAlarmsCommand.prototype.isShownInMenu = function () {
    return !this.$view.isSingleSourceView();
  };

  ShowAlarmsCommand.prototype.selectionChanged = function () {
    this.setEnabled(this.$view.getSelectedAlarmRecords().length === 1 || this.$view.isSingleSourceView());
  };

  return ShowAlarmsCommand;
});
