/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * API Status: **Private**
 * @module nmodule/alarm/rc/console/commands/ContinuousCommand
 */
define(['bajaux/commands/ToggleCommand',
        'nmodule/alarm/rc/console/commands/alarmConsoleCommandMixIn'], function (
        ToggleCommand,
        alarmConsoleCommandMixIn) {

  'use strict';

  /**
   * If selected alarm sounds will play continuously until silenced.
   *
   * @constructor
   * @param {module:nmodule/alarm/rc/console/AlarmConsole} view The alarm console view.
   * @extends {module:bajaux/commands/ToggleCommand}
   * @mixes {module:module:nmodule/alarm/rc/console/commands/alarmConsoleCommandMixIn}
   */
  var ContinuousCommand = function (view) {
    ToggleCommand.apply(this, [{
      module: 'alarm',
      lex: 'commands.continuousAlarm',
      func: function () {
        var state = !view.$getViewModel().$getAudioQueue().isContinuous();

        view.$getViewModel().$getAudioQueue().setContinuous(state);
        view.$getViewModel().$getSupport().setAlarmConsoleOption('soundContinuous', state);
        this.setSelected(state);
      }
    }]);

    alarmConsoleCommandMixIn(this);

    this.$view = view;
  };

  ContinuousCommand.prototype = Object.create(ToggleCommand.prototype);
  ContinuousCommand.prototype.constructor = ContinuousCommand;

  /**
   * Update the state of the toggle command based on the current state
   * of the audio handler.
   */
  ContinuousCommand.prototype.update = function () {
    this.setSelected(this.$view.$getViewModel().$getAudioQueue().isContinuous());
  };

  return ContinuousCommand;
});
