/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/alarm/rc/baja/ext/EnumFaultAlgorithm
 */
define(['baja!',
  'nmodule/alarm/rc/baja/ext/AlarmAlgorithm'], function (baja,
                                                         AlarmAlgorithm) {

  'use strict';

  /**
   * BajaScript representation of an `alarm:EnumFaultAlgorithm` value.
   *
   * @class
   * @extends module:nmodule/alarm/rc/baja/ext/AlarmAlgorithm
   * @alias module:nmodule/alarm/rc/baja/ext/EnumFaultAlgorithm
   */
  var EnumFaultAlgorithm = function EnumFaultAlgorithm() {
    AlarmAlgorithm.apply(this, arguments);
  };
  EnumFaultAlgorithm.prototype = Object.create(AlarmAlgorithm.prototype);
  EnumFaultAlgorithm.prototype.constructor = EnumFaultAlgorithm;

  /**
   * Merge in facets from the parent point for the `validValues` slot.
   * @param {String|baja.Slot} slot
   * @returns {baja.Facets}
   */
  EnumFaultAlgorithm.prototype.getFacets = function (slot) {
    var f = AlarmAlgorithm.prototype.getFacets.apply(this, arguments);

    switch (String(slot)) {
      case 'validValues':
        return baja.Facets.make(this.getPointFacets(), f);
      default:
        return f;
    }
  };

  return EnumFaultAlgorithm;
});
