/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/alarm/rc/baja/ext/EnumChangeOfStateAlgorithm
 */
define(['baja!',
  'nmodule/alarm/rc/baja/ext/AlarmAlgorithm'], function (baja,
                                                         AlarmAlgorithm) {

  'use strict';

  /**
   * BajaScript representation of an `alarm:EnumChangeOfStateAlgorithm` value.
   *
   * @class
   * @extends module:nmodule/alarm/rc/baja/ext/AlarmAlgorithm
   * @alias module:nmodule/alarm/rc/baja/ext/EnumChangeOfStateAlgorithm
   */
  var EnumChangeOfStateAlgorithm = function EnumChangeOfStateAlgorithm() {
    AlarmAlgorithm.apply(this, arguments);
  };
  EnumChangeOfStateAlgorithm.prototype = Object.create(AlarmAlgorithm.prototype);
  EnumChangeOfStateAlgorithm.prototype.constructor = EnumChangeOfStateAlgorithm;

  /**
   * Merge in facets from the parent point for the `alarmValues` slot.
   * @param {String|baja.Slot} slot
   * @returns {baja.Facets}
   */
  EnumChangeOfStateAlgorithm.prototype.getFacets = function (slot) {
    var f = AlarmAlgorithm.prototype.getFacets.apply(this, arguments);

    switch (String(slot)) {
      case 'alarmValues':
        return baja.Facets.make(this.getPointFacets(), f);
      default:
        return f;
    }
  };

  return EnumChangeOfStateAlgorithm;
});
