/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Private**
 * @module nmodule/alarm/rc/baja/AlarmInstructions
 */
define(['baja!',
  'bajaScript/baja/obj/objUtil',
  'underscore'], function (baja, objUtil, _) {

  'use strict';

  var Simple      = baja.Simple,
      cacheDecode = objUtil.cacheDecode,
      cacheEncode = objUtil.cacheEncode;

  var AlarmInstructions = function AlarmInstructions() {
    Simple.apply(this, arguments);
  };
  AlarmInstructions.prototype = Object.create(Simple.prototype);
  AlarmInstructions.prototype.constructor = AlarmInstructions;

  AlarmInstructions.make = function (instructions) {
    if (!Array.isArray(instructions)) {
      throw new Error('array required');
    }

    var ai = new AlarmInstructions();
    ai.$instructions = _.map(_.map(instructions, String), baja.Format.make);
    return ai;
  };

  AlarmInstructions.prototype.make = function () {
    return AlarmInstructions.make.apply(AlarmInstructions, arguments);
  };

  AlarmInstructions.prototype.decodeFromString = cacheDecode(function (str) {
    if (!str) {
      return AlarmInstructions.DEFAULT;
    }
    return AlarmInstructions.make(str.split('\n'));
  });

  AlarmInstructions.prototype.encodeToString = cacheEncode(function () {
    return this.$instructions.join('\n');
  });

  AlarmInstructions.prototype.get = function (i) {
    return this.$instructions[i] || null;
  };

  AlarmInstructions.prototype.getInstructions = function () {
    return this.$instructions.slice();
  };

  AlarmInstructions.prototype.size = function () {
    return this.$instructions.length;
  };

  AlarmInstructions.DEFAULT = AlarmInstructions.make([]);

  baja.registerType('alarm:AlarmInstructions', function () {
    return AlarmInstructions;
  });

  return AlarmInstructions;
});
