function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */
define(['baja!', 'Promise', 'underscore', 'nmodule/webEditors/rc/wb/mgr/model/columns/IconMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/NameMgrColumn', 'nmodule/tagdictionary/rc/column/TagTypeColumn', 'nmodule/webEditors/rc/wb/mgr/model/MgrColumn', 'nmodule/webEditors/rc/wb/table/model/Column', 'nmodule/webEditors/rc/wb/table/tree/TreeTableModel', 'nmodule/webEditors/rc/wb/tree/TreeNode', 'nmodule/tagdictionary/rc/util/taggingUtil', 'nmodule/tagdictionary/rc/taginfo/BaseTagInfoMixin', 'nmodule/tagdictionary/rc/taginfo/TagGroupInfoMixin', 'lex!tagdictionary'], function (baja, Promise, _, IconMgrColumn, NameMgrColumn, TagTypeColumn, MgrColumn, Column, TreeTableModel, TreeNode, taggingUtil, BaseTagInfoMixin, TagGroupInfoMixin, lexs) {
  'use strict';

  var tagdictionaryLex = lexs[0];
  var TAGS_FOLDER_NAME = 'TagsFolder',
      TAG_GROUPS_FOLDER_NAME = 'TagGroupsFolder',
      TAG_FILTER_VALID_ONLY = taggingUtil.TAG_FILTER_VALID_ONLY,
      TAG_FILTER_BEST_ONLY = taggingUtil.TAG_FILTER_BEST_ONLY,
      TAG_FOLDER_ICON = taggingUtil.TAG_FOLDER_ICON; // A standard NameMgrColumn with the displayName overridden

  var TAG_NAME_COL = new NameMgrColumn();

  TAG_NAME_COL.toDisplayName = function () {
    return tagdictionaryLex.getSafe('tagManager.tag');
  };

  var COLUMNS = [new IconMgrColumn(), TAG_NAME_COL, new TagTypeColumn({
    displayName: tagdictionaryLex.getSafe('tagManager.tagType')
  })];
  /**
   * API Status: **Private**
   * @exports nmodule/tagdictionary/rc/model/AvailableTagModel
   */

  var exports = {};
  /**
   * @returns {Promise.<module:nmodule/webEditors/rc/wb/table/tree/TreeTableModel>}
   */

  exports.make = function () {
    return TreeTableModel.make({
      columns: COLUMNS
    });
  };
  /**
   * Populate the manager's learn table with available tags.
   *
   * @param {module:nmodule/tagdictionary/rc/TagUxManager} manager
   * @returns {Promise}
   */


  exports.populateLearnTable = function (manager) {
    var model = manager.getLearnModel(),
        tagInfoDiscoveries = manager.$tagInfos,
        tagGroupInfoDiscoveries = manager.$tagGroupInfos,
        filterParams = manager.$discoveryTableFilterParams,
        showValidOnly = filterParams.showAllValidBest === TAG_FILTER_VALID_ONLY.getTag(),
        showIdealOnly = filterParams.showAllValidBest === TAG_FILTER_BEST_ONLY.getTag(),
        textFilter = filterParams.textFilter;

    function include(baseTagInfoMixin) {
      if (showValidOnly && !baseTagInfoMixin.isValidFor() || showIdealOnly && !baseTagInfoMixin.isIdealFor()) {
        return false;
      }

      if (textFilter) {
        return baseTagInfoMixin.getTagId().getName().match(new RegExp(textFilter, 'gi'));
      }

      return true;
    } // Tags


    var tagNodes = _.chain(tagInfoDiscoveries).filter(include).map(function (tagInfo) {
      return taggingUtil.makeTagTableNode(tagInfo, false);
    }).value(); // Tag Groups


    var tagGroupNodes = _.chain(tagGroupInfoDiscoveries).filter(include).map(function (tagGroupInfo) {
      return taggingUtil.makeTagGroupLearnTableNode(tagGroupInfo);
    }).value();

    var expandTags = false,
        expandTagGroups = false,
        dictionaryHasTagGroups = tagGroupInfoDiscoveries.length > 0;
    model.getRows().forEach(function (row) {
      if (row.getTreeNode().getName() === TAGS_FOLDER_NAME) {
        expandTags = model.isExpanded(row);
      } else if (row.getTreeNode().getName() === TAG_GROUPS_FOLDER_NAME) {
        expandTagGroups = model.isExpanded(row);
      }
    });
    var rootNode = model.getRootNode();
    return Promise.all([rootNode.getKids(), model.clearRows()]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
          kids = _ref2[0],
          unused = _ref2[1];

      return Promise.all(kids.map(function (kid) {
        return rootNode.remove(kid);
      }));
    }).then(function () {
      var tagsFolderNode = makeFolder(TAGS_FOLDER_NAME, tagdictionaryLex.getSafe('tag.objects'), tagNodes);
      var tagGroupsFolderNode = dictionaryHasTagGroups ? makeFolder(TAG_GROUPS_FOLDER_NAME, tagdictionaryLex.getSafe('tagGroup.objects'), tagGroupNodes) : null;
      var rowsToInsert = [model.makeRow(tagsFolderNode)];

      if (tagGroupsFolderNode) {
        rowsToInsert.push(model.makeRow(tagGroupsFolderNode));
      }

      return Promise.all([rootNode.add(tagsFolderNode), tagGroupsFolderNode ? rootNode.add(tagGroupsFolderNode) : undefined, model.insertRows(rowsToInsert, 0)]);
    }).then(function () {
      var expandPromises = [];
      model.getRows().forEach(function (row) {
        if (expandTags && row.getTreeNode().getName() === TAGS_FOLDER_NAME) {
          expandPromises.push(model.expand(row));
        }

        if (expandTagGroups && row.getTreeNode().getName() === TAG_GROUPS_FOLDER_NAME) {
          expandPromises.push(model.expand(row));
        }
      });
      return Promise.all(expandPromises);
    });
  };
  /*
   * Make a container component for TagInfo or TagGroupInfo objects.
   *
   * @param  {String} name
   * @param  {String} displayName
   * @param  {Array.<module:nmodule/tagdictionary/rc/taginfo/BaseTagInfoMixin>} kids
   * @returns {module:nmodule/webEditors/rc/wb/tree/TreeNode}
   */


  var makeFolder = function makeFolder(name, displayName, kids) {
    var folder = new TreeNode(name, displayName, kids);
    var tagFolderComp = baja.$('baja:Component'); // override #getName & #getDisplayName

    tagFolderComp.getName = _.constant(name);
    tagFolderComp.getDisplayName = _.constant(displayName);
    folder.value = _.constant(tagFolderComp);
    folder.getIcon = _.constant(TAG_FOLDER_ICON);
    folder.mayHaveKids = _.constant(true);
    folder.isGroup = _.constant(true);
    return folder;
  };

  return exports;
});
