function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/**
 * Widget to show the filter options for the Component Tags pane.
 *
 * API Status: **Private**
 * @module nmodule/tagdictionary/rc/filter/ComponentTagFilter
 */
define(['baja!', 'lex!tagdictionary', 'jquery', 'underscore', 'Promise', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/baja/BooleanEditor'], function (baja, lexs, $, _, Promise, fe, BaseEditor, BooleanEditor) {
  'use strict';

  var tagdictionaryLex = lexs[0];
  /**
   * Widget to manage filter settings for the Component Tags pane.
   *
   * @class
   * @extends module:bajaux/Widget
   * @alias module:nmodule/tagdictionary/rc/filter/ComponentTagFilter
   * @param {Object} [params]
   * @param {Function} [params.updateFunction] function called when values in the editor change
   */

  var ComponentTagFilter = function ComponentTagFilter(params) {
    this.$updateFunction = params && params.updateFunction ? params.updateFunction : _.noop;
    BaseEditor.apply(this, arguments);
  };

  ComponentTagFilter.prototype = Object.create(BaseEditor.prototype);
  ComponentTagFilter.prototype.constructor = ComponentTagFilter;
  /**
   * Initialize the widget.
   *
   * @param {JQuery} dom the DOM element to load the widget into.
   */

  ComponentTagFilter.prototype.doInitialize = function (dom) {
    var that = this;
    dom.addClass('ComponentTagFilter');
    dom.html('<span class="showDirect" />' + '<span class="showImplied" />');
    dom.on('change', '.showDirect, .showImplied', function () {
      return Promise.all([that.$showDirectEditor.read(), that.$showImpliedEditor.read()]).then(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 2),
            showDirectValue = _ref2[0],
            showImpliedValue = _ref2[1];

        that.$updateFunction({
          showDirect: showDirectValue,
          showImplied: showImpliedValue
        });
      });
    });
    return Promise.all([fe.buildFor({
      dom: dom.find('.showDirect'),
      type: BooleanEditor,
      value: true,
      formFactor: 'mini',
      properties: {
        trueText: tagdictionaryLex.getSafe('tagManager.direct'),
        falseText: tagdictionaryLex.getSafe('tagManager.direct')
      }
    }), fe.buildFor({
      dom: dom.find('.showImplied'),
      type: BooleanEditor,
      value: false,
      formFactor: 'mini',
      properties: {
        trueText: tagdictionaryLex.getSafe('tagManager.implied'),
        falseText: tagdictionaryLex.getSafe('tagManager.implied')
      }
    })]).then(function (_ref3) {
      var _ref4 = _slicedToArray(_ref3, 2),
          showDirectEditor = _ref4[0],
          showImpliedEditor = _ref4[1];

      that.$showDirectEditor = showDirectEditor;
      that.$showImpliedEditor = showImpliedEditor;
    });
  };
  /**
   * Destroy the widget.
   *
   * @returns {Promise|*}
   */


  ComponentTagFilter.prototype.doDestroy = function () {
    this.jq().removeClass('ComponentTagFilter');
    return this.getChildWidgets().destroyAll();
  };

  return ComponentTagFilter;
});
