function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/**
 * Widget to show the filter options for the Available Tags pane.
 *
 * API Status: **Private**
 * @module nmodule/tagdictionary/rc/filter/AvailableTagFilter
 */
define(['baja!', 'baja!tagdictionary:TagDictionary', 'jquery', 'underscore', 'Promise', 'nmodule/js/rc/switchboard/switchboard', 'nmodule/tagdictionary/rc/util/taggingUtil', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/baja/IconEditor', 'nmodule/webEditors/rc/fe/baja/StringEditor', 'nmodule/webEditors/rc/fe/baja/FrozenEnumEditor', 'bajaux/events'], function (baja, types, $, _, Promise, switchboard, taggingUtil, fe, BaseEditor, IconEditor, StringEditor, FrozenEnumEditor, events) {
  'use strict';

  var DICTIONARY_ICON = taggingUtil.DICTIONARY_ICON,
      SEARCH_ICON = taggingUtil.SEARCH_ICON,
      FILTER_ICON = taggingUtil.FILTER_ICON,
      TAG_FILTER_ENUM = taggingUtil.TAG_FILTER_ENUM,
      TAG_FILTER_SHOW_ALL = taggingUtil.TAG_FILTER_SHOW_ALL,
      MODIFY_EVENT = events.MODIFY_EVENT;
  /**
   * Widget to show the filter options for the Available Tags pane.
   *
   * @class
   * @extends module:bajaux/Widget
   * @alias module:nmodule/tagdictionary/rc/filter/AvailableTagFilter
   *
   * @param {Object} [params]
   * @param {Function} [params.updateFunction] function called when values in the editor change
   */

  var AvailableTagFilter = function AvailableTagFilter(params) {
    this.$updateFunction = params && params.updateFunction ? params.updateFunction : _.noop;
    BaseEditor.apply(this, arguments);
    switchboard(this, {
      '$applyFilterChanges': {
        allow: 'oneAtATime',
        onRepeat: 'preempt'
      }
    });
  };

  AvailableTagFilter.prototype = Object.create(BaseEditor.prototype);
  AvailableTagFilter.prototype.constructor = AvailableTagFilter;
  /**
   * Initialize the widget.
   *
   * @param {JQuery} dom the DOM element to load the widget into.
   */

  AvailableTagFilter.prototype.doInitialize = function (dom) {
    var that = this;
    dom.addClass('AvailableTagFilter');
    dom.html('<span class="AvailableTagFilter-icon dictionaryIcon" />' + '<span class="AvailableTagFilter-item dictionarySelect"><select class="ux-select" /></span>' + '<span class="AvailableTagFilter-icon searchIcon" />' + '<span class="AvailableTagFilter-item searchText" />' + '<span class="AvailableTagFilter-icon filterIcon" />' + '<span class="AvailableTagFilter-item filterTypeSelect" />');
    dom.on('change', '.dictionarySelect, .filterTypeSelect', function () {
      that.$applyFilterChanges();
    });
    dom.on('keyup', '.searchText', function () {
      that.$applyFilterChanges();
    });
    var dictionaryIcon = fe.buildFor({
      dom: dom.find('.dictionaryIcon'),
      type: IconEditor,
      value: DICTIONARY_ICON
    });
    var searchIcon = fe.buildFor({
      dom: dom.find('.searchIcon'),
      type: IconEditor,
      value: SEARCH_ICON
    });
    var filterIcon = fe.buildFor({
      dom: dom.find('.filterIcon'),
      type: IconEditor,
      value: FILTER_ICON
    });
    var searchTextBox = fe.buildFor({
      dom: dom.find('.searchText'),
      type: StringEditor,
      value: ''
    }).then(function (ed) {
      that.$searchTextEditor = ed;
    });
    var filterTypeSelect = fe.buildFor({
      dom: dom.find('.filterTypeSelect'),
      type: FrozenEnumEditor,
      value: TAG_FILTER_ENUM
    }).then(function (ed) {
      that.$filterTypeSelectEditor = ed;
      return ed.load(TAG_FILTER_SHOW_ALL);
    });
    return Promise.all([dictionaryIcon, searchIcon, filterIcon, searchTextBox, filterTypeSelect]).then(function () {
      // stop wb thinking something needs to be saved
      dom.on(MODIFY_EVENT, '*', false);
      return that.$populateTagDictionarySelectItems();
    });
  };
  /**
   * Apply changes made to the filter.
   *
   * @private
   * @returns {Promise}
   */


  AvailableTagFilter.prototype.$applyFilterChanges = function () {
    var that = this;
    return Promise.all([Promise.resolve(that.jq().find('.dictionarySelect option:selected').val()), that.$searchTextEditor.read(), that.$filterTypeSelectEditor.read()]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 3),
          dictionary = _ref2[0],
          textFilter = _ref2[1],
          showAllValidBest = _ref2[2];

      that.$updateFunction({
        dictionary: dictionary,
        textFilter: textFilter,
        showAllValidBest: showAllValidBest.getTag()
      });
    });
  };
  /**
   * Populate the Tag Dictionary dropdown.
   *
   * @private
   * @returns {Promise}
   */


  AvailableTagFilter.prototype.$populateTagDictionarySelectItems = function () {
    var that = this,
        selectElement = that.jq().find('.dictionarySelect > select'); // clear out the dropdown options

    selectElement.empty(); // Not currently subscribing to the TagDictionaryService to pick up any changes
    // - on the basis that this won't change very often.

    return taggingUtil.getTagDictionaryService().then(function (service) {
      if (!service) {
        return;
      }

      var dictionaries = []; // TODO use an rpc call to look up the dictionaries, because there could be
      //      tag dictionaries are not implementations of BTagDictionary, they can
      //      also be BComponents that implement the TagDictionary interface.

      service.getSlots().properties().is('tagdictionary:TagDictionary').each(function (prop) {
        dictionaries.push(service.get(prop));
      });
      return Promise.all(dictionaries.map(function (d) {
        return d.lease();
      })).then(function () {
        var optionVal,
            optionDisplay,
            setSelected = true;

        _.each(dictionaries, function (dictionary) {
          optionVal = _.escape(dictionary.getNamespace());
          optionDisplay = _.escape(service.getDisplayName(dictionary.getName()));
          selectElement.append('<option class="ux-option" value="' + optionVal + '">' + optionDisplay + '</option>');

          if (setSelected) {
            selectElement.val(optionVal);
            setSelected = false;
          }
        });
      });
    });
  };
  /**
   * Destroy the widget.
   *
   * @returns {Promise|*}
   */


  AvailableTagFilter.prototype.doDestroy = function () {
    this.jq().removeClass('AvailableTagFilter');
    return this.getChildWidgets().destroyAll();
  };

  return AvailableTagFilter;
});
