/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/**
 * API Status: **Private**
 * @module nmodule/tagdictionary/rc/commands/TagManagerCommand
 */
define(['baja!', 'lex!webEditors', 'jquery', 'bajaux/commands/Command', 'bajaux/util/CommandButtonGroup', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/tagdictionary/rc/util/taggingUtil', 'nmodule/tagdictionary/rc/TagUxManager'], function (baja, lexs, $, Command, CommandButtonGroup, fe, feDialogs, taggingUtil, TagUxManager) {
  'use strict';

  var webEditorsLex = lexs[0];
  /**
   * Command for popping up a TagManager.
   *
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/tagdictionary/rc/commands/TagManagerCommand
   * @param {baja.Component} component
   */

  var TagManagerCommand = function TagManagerCommand(component) {
    Command.call(this, {
      module: 'tagdictionary',
      lex: 'commands.tagManager',
      func: function func() {
        return feDialogs.showFor({
          type: TagUxManager,
          singleComponentMode: true,
          properties: {
            showHeader: false,
            showFooter: false
          },
          value: component,
          formFactor: 'max',
          progressCallback: function progressCallback(msg, manager) {
            switch (msg) {
              case 'initialized':
                {
                  // After the dialog has initialized, do a bit of reformatting/rearranging
                  var dialogJq = manager.$dlg.$dialogJq; // This is dialog container ('.js-dialog-container'),
                  // it includes the dialog buttons that we're interested in here.
                  // manager.jq() ('.js-dialog-content > .Manager') just provides
                  // the dialog content and does not include the dialog buttons.
                  // change text on 'ok' button, as any updates will already have been committed

                  var okButton = dialogJq.find('.js-dialog-button-content  button.js-dialog-button-ok');
                  okButton.text(webEditorsLex.get('close')); // don't need the cancel button, as 'ok' does the same thing, ie nothing.

                  var cancelButton = dialogJq.find('.js-dialog-button-content  button.js-dialog-button-cancel');
                  cancelButton.hide();
                  var actionCommandsElement = manager.jq().find('.mgr-action-bar'),
                      dialogCommandContainer = dialogJq.find('ul.js-dialog-button-content'); // empty the original commands element and reduce its size to zero
                  // we need to keep the element itself as MgrLearnTableSupport uses the element to calculate sizes

                  actionCommandsElement.empty();
                  actionCommandsElement.css({
                    padding: '0px'
                  }); // This makes discovery and database tables size
                  // size correctly, weirdly doesn't work if placed
                  // in tagdictionary.css
                  // create a new set of commands and insert them into the dialog before the (renamed) OK button

                  return fe.buildFor({
                    dom: $('<div/>').prependTo(dialogCommandContainer),
                    type: CommandButtonGroup,
                    value: manager.getCommandGroup().filter({
                      include: taggingUtil.filterCommands
                    })
                  }).then(function () {
                    manager.$getAddCommand().setEnabled(true);
                  });
                }
            }
          }
        });
      }
    });
  };

  TagManagerCommand.prototype = Object.create(Command.prototype);
  TagManagerCommand.prototype.constructor = TagManagerCommand;
  return TagManagerCommand;
});
