/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/**
 * API Status: **Private**
 * @module nmodule/tagdictionary/rc/commands/RemoveComponentCommand
 */
define(['baja!', 'bajaux/commands/Command'], function (baja, Command) {
  'use strict';
  /**
   * Command for removing components from the SelectedComponents table in a TagUxManager view.
   *
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/tagdictionary/rc/commands/RemoveComponentCommand
   * @param {module:nmodule/webEditors/rc/wb/mgr/Manager} manager
   */

  var RemoveComponentCommand = function RemoveComponentCommand(manager) {
    var that = this;
    Command.call(that, {
      module: 'tagdictionary',
      lex: 'commands.tagManager.removeComponent',
      enabled: false,

      /**
       * Takes the components that are currently selected in the manager's
       * selectedComponents table, and removes them from the model.
       * @returns {Promise}
       */
      func: function func() {
        // No need for permissions, it's not a delete, just removing it from the selected comps model
        return manager.getSelectedComponentsModel().removeRows(manager.getSelectedComponentsTable().getSelectedRows());
      }
    });
  };

  RemoveComponentCommand.prototype = Object.create(Command.prototype);
  RemoveComponentCommand.prototype.constructor = RemoveComponentCommand;
  return RemoveComponentCommand;
});
