function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/* jshint browser: true */

/**
 * API Status: **Private**
 * @module nmodule/tagdictionary/rc/commands/AddTagCommand
 */
define(['baja!', 'baja!tagdictionary:SimpleTagInfo', 'lex!tagdictionary,workbench', 'Promise', 'underscore', 'dialogs', 'bajaux/commands/Command', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/mgr/BatchComponentEditor', 'nmodule/webEditors/rc/wb/mgr/mgrUtils', 'nmodule/webEditors/rc/wb/mgr/model/MgrModel', 'nmodule/tagdictionary/rc/util/taggingUtil', 'nmodule/tagdictionary/rc/taginfo/TagInfoMixin', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/StringEditor'], function (baja, types, lexs, Promise, _, dialogs, Command, feDialogs, BatchComponentEditor, mgrUtils, MgrModel, taggingUtil, TagInfoMixin, fe, StringEditor) {
  'use strict';

  var tagdictionaryLex = lexs[0],
      workbenchLex = lexs[1],
      getLearnTableSelectedSubjects = mgrUtils.getLearnTableSelectedSubjects,
      setProposedValues = mgrUtils.setProposedDiscoveryValues,
      toMgrTypeInfos = mgrUtils.toMgrTypeInfos;

  function getRowSubjects(rows) {
    return _.invoke(rows, 'getSubject');
  }
  /**
   * Creates an array of slot names for the given rows.
   * In this case they're just used to populate slots on the BatchComponentEditor,
   * they are not the tag/tag group slot names
   *
   * @param {Array.<module:nmodule/webEditors/rc/wb/table/model/Row>} rows
   * @param {baja.Component} origContainer
   * @returns {Array.<String>}
   */


  function generateSlotNamesForRows(rows, origContainer) {
    var slotNum = 0;
    var uniqueName = 'AddTagModel';
    return _.map(rows, function (row) {
      return uniqueName + slotNum++;
    });
  }
  /**
   * Returns a new `MgrModel` containing rows representing the items
   * to be added from the discovery table to the database table. This will
   * be used to present the batch component editor before the rows
   * are added to the main model's component source.
   */


  function makeModelForNewRows(rows) {
    var source = baja.$('baja:Folder'),
        slotNames = generateSlotNamesForRows(rows),
        addModel = new MgrModel({
      componentSource: source,
      columns: taggingUtil.STANDARD_TAG_COLUMNS
    });

    _.each(rows, function (row, index) {
      source.add({
        slot: slotNames[index],
        value: row.getSubject()
      });
    });

    return addModel.insertRows(rows, 0).then(_.constant(addModel));
  }
  /**
   * Shows the `BatchComponentEditor` in a dialog with the `Rows`
   * created from the discovery nodes dragged or selected in the
   * learn table. Once the edit is confirmed, the newly dropped
   * tags are added to the component(s) in the station.
   *
   * @param {module:nmodule/webEditors/rc/wb/mgr/Manager} mgr the manager instance
   * @param {Array.<module:nmodule/webEditors/rc/wb/table/model/Row>} rows
   * @param {module:nmodule/webEditors/rc/wb/mgr/model/MgrModel} modelToAddTo the model we're adding tags to
   */


  function addNewInstances(mgr, rows, modelToAddTo) {
    /*
     * Skip the BatchComponentEditor stage if we're only adding Markers and/or TagGroups
     * (as they don't have a value that can be edited)
     */
    function bypassBatchEditor(model) {
      return _.every(getRowSubjects(model.getRows()), function (subject) {
        return subject.getType().is('tagdictionary:TagGroupInfo') || subject.getDefaultValue().getType().is('baja:Marker');
      });
    }

    return Promise.all([mgr.getOrdBase(), makeModelForNewRows(rows)]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
          ordBase = _ref2[0],
          edModel = _ref2[1];

      var editorPromise = bypassBatchEditor(edModel) ? Promise.resolve(edModel) : feDialogs.showFor({
        value: edModel,
        properties: {
          ordBase: ordBase
        },
        type: BatchComponentEditor
      });
      return editorPromise.then(function (editorModel) {
        var newRows, newInstances, duplicate;

        if (editorModel) {
          // Look at the names of the tags we are being asked to add.
          // If any of the tags match existing (non-implied) tags, we'll go
          // back and present the add dialog again, to let the user change
          // their selection.
          newRows = editorModel.getRows();
          newInstances = getRowSubjects(newRows);
          duplicate = modelToAddTo.findDuplicateTagName(newInstances);

          if (!duplicate) {
            return modelToAddTo.addInstances(newInstances);
          } else {
            throw new Error(tagdictionaryLex.get('mgr.duplicateTagName', duplicate)); // no point in going back to the BatchEditor like the standard AddCommoand,
            // as you can't change the tag name in that dialog
          }
        }
      })["catch"](feDialogs.error);
    });
  }
  /**
   * Command for adding discovered items to the station database. The command action can be
   * invoked directly by clicking on the button, or can be invoked by a drag and drop from
   * the discovery table to the main table.
   *
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/tagdictionary/rc/commands/AddTagCommand
   * @param {module:nmodule/webEditors/rc/wb/mgr/MgrLearn} mgr
   */


  var AddTagCommand = function AddTagCommand(mgr) {
    Command.call(this, {
      module: 'tagdictionary',
      lex: 'commands.tagManager.addTag',
      enabled: false,

      /**
       * When this command is invoked, we should take the selected components in the discovery
       * table and present a dialog for editing them, before adding them to the station.
       *
       * @alias module:nmodule/tagdictionary/rc/commands/AddTagCommand#invoke
       * @returns {Promise}
       */
      func: function func() {
        var tagSelection, componentSelection;
        var useComponentSelection = mgr.hasMixIn('SELECTED_COMPONENTS_TABLE'),
            dbModelToAddTo = useComponentSelection ? mgr.getSelectedComponentsModel() : mgr.getModel();

        function getSelectedComponentsSelectedSubjects(mgr) {
          return _.invoke(mgr.getSelectedComponentsTable().getSelectedRows(), 'getSubject');
        }

        if (useComponentSelection) {
          componentSelection = getSelectedComponentsSelectedSubjects(mgr);

          if (!componentSelection.length) {
            return Promise.resolve();
          }
        } else {
          if (!mgr.value()) {
            return Promise.resolve();
          }
        } // Obtain the current selection from the discovery table - these
        // are the items that were dragged or selected. We then map those items to
        // new Rows for the main manager table, and show the editor dialog
        // to configure them before they are added to the station.


        tagSelection = getLearnTableSelectedSubjects(mgr); // if there is no selection from the discovery table, show the Add Adhoc Tag dialog

        if (!tagSelection.length) {
          var tagIdEditor, selectElement;
          return dialogs.showOkCancel({
            title: tagdictionaryLex.getSafe('commands.tagManager.addTag.add.adhoc'),
            content: function content(dlg, jq) {
              jq.empty();
              jq.html('<div class="add-ad-hoc-tag">' + '<table><tbody>' + '<tr><td>' + workbenchLex.getSafe('add.tag.tagId') + '</td><td><div class="tag-id"/></td></tr>' + '<tr><td>' + workbenchLex.getSafe('add.tag.type') + '</td><td><select class="ux-select tag-type-select"/></td></tr>' + '</tbody></table>' + '</div>');
              return Promise.all([baja.registry.getConcreteTypes({
                type: 'baja:IDataValue'
              }), fe.buildFor({
                dom: jq.find('.tag-id'),
                type: StringEditor,
                value: '',
                formFactor: 'mini'
              })]).then(function (_ref3) {
                var _ref4 = _slicedToArray(_ref3, 2),
                    tagValueTypes = _ref4[0],
                    stringEditor = _ref4[1];

                selectElement = jq.find('.tag-type-select');
                tagValueTypes.forEach(function (type) {
                  selectElement.append('<option class="ux-option" value="' + type.toString() + '">' + type.toString() + '</option>');

                  if (type.is('baja:Marker')) {
                    selectElement.val(type.toString());
                  }
                });
                tagIdEditor = stringEditor;
              });
            }
          }).ok(function () {
            return tagIdEditor.read().then(function (tagIdStr) {
              if (!taggingUtil.isValidTagId(tagIdStr)) {
                throw new Error(workbenchLex.get({
                  key: 'add.tag.error.invalid.id',
                  args: [tagIdStr]
                }));
              }

              var tagType = selectElement.val(),
                  // create the equivalent of a discovery subject
              tagInfoMixin = new TagInfoMixin(new baja.Id(tagIdStr), baja.$(tagType), 'tagdictionary:SimpleTagInfo', false, false, tagType);
              tagInfoMixin.setIsAdHoc(true);
              return mgr.newInstanceFromDiscoverySubject(tagInfoMixin);
            }).then(function (instance) {
              return addNewInstances(mgr, [dbModelToAddTo.makeRow(instance)], dbModelToAddTo);
            })["catch"](feDialogs.error);
          }).promise();
        } // First we query the manager for the types for each item
        // being dropped. If the value resolved from the call to
        // getTypesForDiscoverySubject() is not a MgrTypeInfo (or an
        // array of), we ensure we create them ourselves. We then
        // create a new instance, which unless the concrete manager
        // has overridden the function, will simply call the
        // #newInstance() function on the first MgrTypeInfo we have.


        return Promise.all(tagSelection.map(function (discovery) {
          var row, typeInfos;
          return Promise.resolve(mgr.getTypesForDiscoverySubject(discovery)).then(toMgrTypeInfos).then(function (ts) {
            typeInfos = ts;
            return mgr.newInstanceFromDiscoverySubject(discovery, typeInfos);
          }).then(function (comp) {
            row = dbModelToAddTo.makeRow(comp);
            return setProposedValues(mgr, dbModelToAddTo, discovery, row);
          }).then(function () {
            return row;
          });
        })).then(function (rows) {
          return addNewInstances(mgr, rows, dbModelToAddTo);
        });
      }
    });
  };

  AddTagCommand.prototype = Object.create(Command.prototype);
  AddTagCommand.prototype.constructor = AddTagCommand;
  /**
   * Override setEnabled so the AddTag Command is always available.
   * By default MgrLearnTableSupport (#notifyAddCommand) disables the Manager's
   * Add Command if no learn table items are selected.
   * The Add Tag Command is used to add an ad hoc if no learn items (Available Tags)
   * are selected.
   *
   * @param {Boolean} enabled
   */

  AddTagCommand.prototype.setEnabled = function (enabled) {
    return Command.prototype.setEnabled.call(this, true);
  };

  return AddTagCommand;
});
