/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/**
 * API Status: **Private**
 * @module nmodule/tagdictionary/rc/column/TagTypeColumn
 */
define(['baja!', 'nmodule/webEditors/rc/wb/mgr/model/MgrColumn', 'nmodule/tagdictionary/rc/taginfo/TagInfoMixin', 'nmodule/tagdictionary/rc/taginfo/TagGroupInfoMixin', 'lex!tagdictionary'], function (baja, MgrColumn, TagInfoMixin, TagGroupInfoMixin, lexs) {
  'use strict';

  var tagdictionaryLex = lexs[0],
      TAG_GROUP_VALUE = tagdictionaryLex.getSafe('tagGroup'); // Note, in wb, ie BTagDictionaryPane.java this is a hard-coded string ('Tag Group')

  /**
   * @class
   * @alias module:nmodule/tagdictionary/rc/column/TagTypeColumn
   * @extends module:nmodule/webEditors/rc/wb/mgr/model/MgrColumn
   * @param {Object} params
   */

  var TagTypeColumn = function TagTypeColumn(params) {
    MgrColumn.call(this, 'tagType', params || {});
  };

  TagTypeColumn.prototype = Object.create(MgrColumn.prototype);
  TagTypeColumn.prototype.constructor = TagTypeColumn;
  /**
   * Returns the value represented by this row.
   *
   * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
   * @returns {*}
   */

  TagTypeColumn.prototype.getValueFor = function (row) {
    if (row.getTreeNode().isGroup()) {
      // ie it's a folder
      return '';
    } // TagGroups


    if (row.getTreeNode().isTagGroup()) {
      // when used by AvailableTagsModel expecting TagGroupInfoMixin
      if (row.getSubject() instanceof TagGroupInfoMixin) {
        return '';
      } // when used by ComponentTagModel expecting Relation.js


      return TAG_GROUP_VALUE;
    } // Tags


    var subject = row.getSubject(); // when used by AvailableTagsModel expecting TagInfoMixin

    if (subject instanceof TagInfoMixin || subject.$tagInfoMixedIn) {
      return subject.getDefaultValue().getType().getTypeName();
    } // when used by ComponentTagModel expecting Tag.js


    return subject.getValue().getType().getTypeName();
  };

  return TagTypeColumn;
});
