/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/**
 * API Status: **Private**
 * @module nmodule/tagdictionary/rc/column/TagNameColumn
 */
define(['baja!', 'underscore', 'nmodule/webEditors/rc/wb/mgr/model/MgrColumn', 'nmodule/tagdictionary/rc/taginfo/BaseTagInfoMixin'], function (baja, _, MgrColumn, BaseTagInfoMixin) {
  'use strict';
  /**
   * @class
   * @alias module:nmodule/tagdictionary/rc/column/TagNameColumn
   * @extends module:nmodule/webEditors/rc/wb/mgr/model/MgrColumn
   * @param {Object} params
   */

  var TagNameColumn = function TagNameColumn(params) {
    MgrColumn.call(this, 'tagName', params || {});
  };

  TagNameColumn.prototype = Object.create(MgrColumn.prototype);
  TagNameColumn.prototype.constructor = TagNameColumn;
  /**
   * Returns the value represented by this row.
   *
   * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
   * @returns {*}
   */

  TagNameColumn.prototype.getValueFor = function (row) {
    if (row.getTreeNode().isGroup()) {
      // a folder (not a Tag Group)
      return '';
    }

    var subject = row.getSubject(); // when used by AddTagCommand subject is either an implementation of BaseTagInfoMixin,
    // or a component with BaseTagInfoMixin mixed-in

    if (subject.$tagInfoMixedIn || subject instanceof BaseTagInfoMixin) {
      return subject.getTagId().getName();
    } // when used by ComponentTagModel subject is Tag.js, Relation.js,


    return subject.$getTagGroupId ? baja.SlotPath.unescape(subject.$getTagGroupId().getName()) : subject.getId().getName();
  };

  return TagNameColumn;
});
