/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/**
 * API Status: **Private**
 * @module nmodule/tagdictionary/rc/column/TagIdColumn
 */
define(['baja!', 'nmodule/webEditors/rc/wb/mgr/model/MgrColumn', 'nmodule/tagdictionary/rc/taginfo/BaseTagInfoMixin'], function (baja, MgrColumn, BaseTagInfoMixin) {
  'use strict';
  /**
   * @class
   * @alias module:nmodule/tagdictionary/rc/column/TagIdColumn
   * @extends module:nmodule/webEditors/rc/wb/mgr/model/MgrColumn
   * @param {Object} params
   */

  var TagIdColumn = function TagIdColumn(params) {
    MgrColumn.call(this, 'tagId', params || {});
  };

  TagIdColumn.prototype = Object.create(MgrColumn.prototype);
  TagIdColumn.prototype.constructor = TagIdColumn;
  /**
   * Returns the value represented by this row.
   *
   * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
   * @returns {*}
   */

  TagIdColumn.prototype.getValueFor = function (row) {
    if (row.getTreeNode().isGroup()) {
      // a folder (not a Tag Group)
      return '';
    }

    if (row.getTreeNode().isTagGroup()) {
      //  not using TreeNode#toDisplay() because it returns a Promise
      return baja.SlotPath.unescape(row.getTreeNode().$display);
    }

    var subject = row.getSubject(); // when used by AddTagCommand subject is either an implementation of BaseTagInfoMixin,
    // or a component with BaseTagInfoMixin mixed-in

    if (subject.$tagInfoMixedIn || subject instanceof BaseTagInfoMixin) {
      return subject.getTagId().getQName();
    } // when used by ComponentTagModel subject is Tag.js, Relation.js,


    return subject.getId().getQName();
  };

  return TagIdColumn;
});
