/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 */
define(['baja!', 'baja!videoDriver:VideoCompressionEnum,' + 'videoDriver:VideoFrameRateEnum,' + 'videoDriver:VideoResolutionEnum', 'underscore'], function (baja, types, _) {
  'use strict';

  var isNumber = _.isNumber,
      isString = _.isString;
  /**
   * API Status: **Private**
   * @exports module:nmodule/naxisvideo/rc/naxisvideo/naxisVideoUtils
   */

  var exports = {};
  /**
   * Converts from `videoDriver:VideoCompressionEnum` to a JPEG compression
   * level (0-100 where 100 is best quality).
   * @param {number|string|baja.Enum} en
   * @returns {number}
   */

  exports.getCompression = function (en) {
    if (isNumber(en)) {
      return en;
    }

    switch (toTag(en, 'videoDriver:VideoCompressionEnum')) {
      case 'none':
        return 0;

      case 'low':
        return 10;

      case 'medium':
        return 30;

      case 'high':
        return 80;
    }
  };
  /**
   * Converts from `videoDriver:VideoFrameRateEnum` to FPS.
   * @param {number|string|baja.Enum} en
   * @returns {number}
   */


  exports.getFps = function (en) {
    if (typeof en === 'number') {
      return en;
    }

    switch (toTag(en, 'videoDriver:VideoFrameRateEnum')) {
      case 'low':
        return 4;

      case 'medium':
        return 15;

      case 'high':
        return 30;
    }
  };
  /**
   * Converts from `videoDriver:VideoResolutionEnum` to a pixel multiplier.
   * @param {number|string|baja.Enum} en
   * @param {baja.Struct} resolutionSettings a 'videoDriver:AxisVideoResolutionSettings' struct
   * @returns {string}
   */


  exports.getResolution = function (en, resolutionSettings) {
    switch (toTag(en, 'videoDriver:VideoResolutionEnum')) {
      case 'low':
        return resolutionSettings.getLow();

      case 'medium':
        return resolutionSettings.getMedium();

      case 'high':
        return resolutionSettings.getHigh();
    }
  };

  function validateType(en, type) {
    if (!baja.hasType(en, type)) {
      throw new Error(type + ' required');
    }
  }

  function toTag(en, type) {
    if (isString(en)) {
      en = baja.$(type, en);
    }

    validateType(en, type);
    return en.getTag();
  }

  return exports;
});
