/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/**
 * @private
 * @module nmodule/jsonToolkit/rc/fe/SlotOrdEditor
 */
define([
    'baja!',
    'log!nmodule.jsonToolkit.rc.fe.SlotOrdEditor',
    'Promise',
    'underscore',
    'nmodule/webEditors/rc/wb/links/OrdChooser',
    'nmodule/webEditors/rc/wb/tree/BajaComplexTreeNode',
    'nmodule/webEditors/rc/fe/baja/util/spaceUtils',
    'nmodule/webEditors/rc/wb/tree/stationTree',
    'css!nmodule/jsonToolkit/rc/jsonToolkit'
  ], function (
    baja,
    log,
    Promise,
    _,
    OrdChooser,
    BajaComplexTreeNode,
    spaceUtils,
    stationTree
  ) {

  'use strict';

  /**
   * A field editor for working with the 'binding' ('baja:Ord') slot on a
   * 'jsonToolkit:JsonSchemaBoundMember' component
   *
   * @private
   * @class
   * @extends module:nmodule/webEditors/rc/wb/links/OrdChooser
   * @alias module:nmodule/jsonToolkit/rc/fe/SlotOrdEditor
   */
  var SlotOrdEditor = function SlotOrdEditor() {
    OrdChooser.apply(this, arguments);
  };

  SlotOrdEditor.prototype = Object.create(OrdChooser.prototype);
  SlotOrdEditor.prototype.constructor = SlotOrdEditor;

  /**
   * Override $resolveTreeRootNode to show only the Config container.
   *
   * @private
   * @returns {Promise} promise to be resolved with the component
   * instance at which to root the tree
   */
  SlotOrdEditor.prototype.$resolveTreeRootNode = function () {
    return this.getOrdBase()
      .then(spaceUtils.resolveStation)
      .then(function (station) {
        return stationTree.makeSessionNode(
          [ new BajaComplexTreeNode(station) ]
        );
      });
  };

  return (SlotOrdEditor);
});
