/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview Include this file to register all available Px Widgets on
 * their corresponding Baja types via baja.registerType().
 * 
 * @author Logan Byam
 * @version 0.0.2.0
 */
define(['baja!', 'baja!bajaui:BorderPane,bajaui:BoundTable,bajaui:Button,' + 'bajaui:CanvasPane,bajaui:CheckBox,bajaui:HyperlinkLabel,' + 'bajaui:Label,bajaui:NullWidget,bajaui:Picture,' + 'bajaui:RootContainer,bajaui:ScrollBar,bajaui:ScrollPane,' + 'bajaui:Shape,bajaui:Slider,bajaui:ToggleButton,bajaui:Widget,' + 'kitPx:Bargraph,kitPx:BoundLabel,kitPx:ForwardButton,' + 'kitPx:GenericFieldEditor,kitPx:ImageButton,' + 'kitPx:LocalizableButton,kitPx:LocalizableLabel,kitPx:LogoffButton,' + 'kitPx:RefreshButton,kitPx:SaveButton,kitPx:SetPointFieldEditor,' + 'mobile:BasicMobilePane,mobile:MobileGridPane,' + 'mobile:MobileJavaScriptButton,kitPx:BackButton', 'underscore', 'mobile/px/widgets/BackButton', 'mobile/px/widgets/Bargraph', 'mobile/px/widgets/BasicMobilePane', 'mobile/px/widgets/BorderPane', 'mobile/px/widgets/BoundLabel', 'mobile/px/widgets/BoundTable', 'mobile/px/widgets/Button', 'mobile/px/widgets/CanvasPane', 'mobile/px/widgets/ForwardButton', 'mobile/px/widgets/GenericFieldEditor', 'mobile/px/widgets/HyperlinkLabel', 'mobile/px/widgets/IgnoreWidget', 'mobile/px/widgets/ImageButton', 'mobile/px/widgets/Label', 'mobile/px/widgets/LocalizableButton', 'mobile/px/widgets/LocalizableLabel', 'mobile/px/widgets/LogoffButton', 'mobile/px/widgets/MobileGridPane', 'mobile/px/widgets/MobileJavaScriptButton', 'mobile/px/widgets/Picture', 'mobile/px/widgets/RefreshButton', 'mobile/px/widgets/RootContainer', 'mobile/px/widgets/SaveButton', 'mobile/px/widgets/ScrollPane', 'mobile/px/widgets/SetPointFieldEditor', 'mobile/px/widgets/Slider', 'mobile/px/widgets/ToggleButton', 'mobile/px/widgets/Widget'], function (baja, types, _, BackButton, Bargraph, BasicMobilePane, BorderPane, BoundLabel, BoundTable, Button, CanvasPane, ForwardButton, GenericFieldEditor, HyperlinkLabel, IgnoreWidget, ImageButton, Label, LocalizableButton, LocalizableLabel, LogoffButton, MobileGridPane, MobileJavaScriptButton, Picture, RefreshButton, RootContainer, SaveButton, ScrollPane, SetPointFieldEditor, Slider, ToggleButton, Widget) {
  "use strict";

  return function registerWidgets() {
    _.each({
      'kitPx:BackButton': BackButton,
      'kitPx:Bargraph': Bargraph,
      'mobile:BasicMobilePane': BasicMobilePane,
      'bajaui:BorderPane': BorderPane,
      'kitPx:BoundLabel': BoundLabel,
      'bajaui:BoundTable': BoundTable,
      'bajaui:Button': Button,
      'bajaui:CanvasPane': CanvasPane,
      'bajaui:CheckBox': ToggleButton,
      'kitPx:ForwardButton': ForwardButton,
      'kitPx:GenericFieldEditor': GenericFieldEditor,
      'bajaui:HyperlinkLabel': HyperlinkLabel,
      'kitPx:ImageButton': ImageButton,
      'bajaui:Label': Label,
      'kitPx:LocalizableButton': LocalizableButton,
      'kitPx:LocalizableLabel': LocalizableLabel,
      'kitPx:LogoffButton': LogoffButton,
      'mobile:MobileGridPane': MobileGridPane,
      'mobile:MobileJavaScriptButton': MobileJavaScriptButton,
      'bajaui:Picture': Picture,
      'kitPx:RefreshButton': RefreshButton,
      'bajaui:RootContainer': RootContainer,
      'kitPx:SaveButton': SaveButton,
      'bajaui:ScrollPane': ScrollPane,
      'kitPx:SetPointFieldEditor': SetPointFieldEditor,
      'bajaui:Slider': Slider,
      'bajaui:ToggleButton': ToggleButton,
      'bajaui:Widget': Widget,
      'bajaui:NullWidget': IgnoreWidget,
      'bajaui:ScrollBar': IgnoreWidget,
      'bajaui:Shape': IgnoreWidget
    }, function (ctor, typeSpec) {
      return baja.registerType(typeSpec, function () {
        return ctor;
      });
    });
  };
});
