function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview The base Widget class used for the mobile Px app.
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */

/**
 * @private
 * @module mobile/px/widgets/Widget
 */
define(['baja!', 'Promise', 'underscore', 'mobile/px/util.px', 'mobile/px/gx/gxStyles', 'baja!bajaui:Widget,bajaui:CanvasPane'], function (baja, Promise, _, pxUtil, gxStyles, types) {
  "use strict";

  var noop = baja.noop,
      Component = baja.Component,
      applyCssFromSimple = gxStyles.applyCssFromSimple,
      hasUpdateAll = pxUtil.hasUpdateAll,
      hasUpdateEnabled = pxUtil.hasUpdateEnabled,
      _types = _slicedToArray(types, 1),
      widgetType = _types[0];
  /**
   * The base Widget that represents Niagara's 'bajaui:Widget' Type.
   *
   * @private
   * @class
   * @alias module:mobile/px/widgets/Widget
   * @extends baja.Component
   */


  var Widget = function Widget() {
    Component.apply(this, arguments);
    this.$dom = null;
  };

  Widget.prototype = Object.create(Component.prototype);
  Widget.prototype.constructor = Widget;
  /**
   * Return the DOM element for the Widget.
   *
   * @return {Object} the DOM element
   */

  Widget.prototype.getDomElement = function () {
    return this.$dom;
  };
  /**
   * Append the Widget's DOM content onto the specified DOM element.
   * 
   * By default, this method throws an error as it's designed to be overridden.
   * 
   * Anything that implements this method should assign the associated DOM element for the
   * Widget to the '$dom' attribute.
   *
   * @param {JQuery} dom DOM element to append content to.
   */


  Widget.prototype.load = function (dom) {
    throw new Error("Unsupported Widget: " + this.getType());
  };
  /**
   * Called after the Widget has loaded and any enhancements have 
   * been made to the DOM.
   *
   * @function
   */


  Widget.prototype.postLoad = noop;
  /**
   * Load the child Widgets.
   * 
   * {@link baja.Widget#load} must be called before this method is invoked.
   *
   * @function
   */

  Widget.prototype.loadChildren = function (dom) {
    dom = dom || this.$dom; // Load all child Widget content...

    this.getSlots(function (slot) {
      // Iterate through all Widget Properties
      return slot.isProperty() && slot.getType().is(widgetType);
    }).each(function (slot) {
      // Load the Content on all Widget Properties
      var widget = this.get(slot);
      widget.load(dom);
      widget.loadChildren();
    });
  };
  /**
   * Update the DOM associated with this Widget.
   * 
   * This function should not typically be overridden. It will delegate
   * widget-specific behavior to the `doUpdate` method.
   *
   * @param {Function} [hasUpdate] called to test whether a
   * given Property can update the DOM. It will take a String property name
   * and return `true` if there are changes to that property that should be
   * applied to the DOM.
   * @param {Boolean} [firstUpdate] set to true on Widgets first update when
   * the page is first loaded.
   * @returns {Promise} promise to be resolved when the widget has fully
   * updated.
   */


  Widget.prototype.update = function (hasUpdate, firstUpdate) {
    hasUpdate = hasUpdate || hasUpdateAll;
    var that = this,
        dom = that.$dom,
        prom; // Bail if there's no DOM element available

    if (!dom) {
      return Promise.resolve();
    }

    if (hasUpdate("visible")) {
      dom.toggle(that.getVisible());
    }

    if (hasUpdate("enabled") && !firstUpdate) {
      // If the enabled state of this Widget has changed then update all of the child Widgets
      var kids = that.getSlots().is(widgetType).toValueArray();
      prom = Promise.all(_.map(kids, function (kid) {
        return kid.update(hasUpdateEnabled);
      }));
    }

    if (hasUpdate("layout") && this.getParent() && this.getDomElement()) {
      // If the parent Widget supports laying out children then call it
      that.getParent().layoutChild(this);
    }

    return Promise.all([prom, that.doUpdate(hasUpdate, firstUpdate)]);
  };
  /**
   * Given a baja Property of this Widget, such as `foreground` or `font`,
   * read the corresponding Property and apply CSS rules as appropriate. For
   * built-in Simples `Brush`, `Color`, `Font`, `Insets`, and `Layout`, CSS
   * styles will be calculated by the framework. For any other Simple
   * properties, it is expected that there will a Type Extension for that
   * Simple with an `update()` function to apply its own CSS rules.
   *
   * @param {string} property the name of a Property slot on this Widget
   * @param {...*} args
   * @returns {*} the result of any overridden `update()` method on a Simple
   * type extension.
   */


  Widget.prototype.applyCssFromSlot = function (property) {
    for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }

    return applyCssFromSimple.apply(void 0, [this.get(property)].concat(args));
  };
  /**
   * Override this method to perform the work of updating the DOM to reflect
   * the widget's current state. It takes the same arguments as `update`,
   * but `hasUpdate` is guaranteed to be present and so can always be
   * safely called.
   * 
   * @param {Function} hasUpdate
   * @param {Boolean} [firstUpdate]
   */


  Widget.prototype.doUpdate = function (hasUpdate, firstUpdate) {}; // Check to make sure all parent Widgets are enabled


  function checkParentWidgetsEnabled(widget) {
    if (widget === null) {
      return true;
    }

    if (!widget.getEnabled()) {
      return false;
    }

    return checkParentWidgetsEnabled(widget.getParent());
  }
  /**
   * Return true if the Widget (and all parent Widgets) are enabled.
   *
   * @return {Boolean}
   */


  Widget.prototype.isEnabled = function () {
    return checkParentWidgetsEnabled(this);
  };
  /**
   * Handle a UI Widget event.
   * 
   * By default, this method will return immediately if the Widget is disabled.
   * {@link Widget#doHandleEvent} will then be called for any subclasses.
   * The event will then get passed onto each binding.
   *
   * @param {String} eventName the name of the event being fired.
   */


  Widget.prototype.handleEvent = function (eventName) {
    // If this or any parent Widget aren't enabled then don't process the event
    if (!this.isEnabled(this)) {
      return;
    } // Let any subclasses handle the event


    if (this.doHandleEvent(eventName)) {
      return;
    } // Forward event to all registered bindings


    this.getSlots(function (s) {
      return s.isProperty() && s.getType().is("bajaui:Binding");
    }).eachValue(function (binding) {
      if (binding.handleEvent(eventName)) {
        return true;
      }
    });
  };
  /**
   * Handle a UI Widget event. 
   * 
   * This method is designed to be overriden and will only be called
   * if the Widget is enabled.
   *
   * @see Widget#doHandleEvent
   *
   * @function
   *
   * @param {String} eventName the name of the event.
   * @returns {Boolean} return true if the event shouldn't bubble through to the Widget's bindings.
   */


  Widget.prototype.doHandleEvent = noop;
  /**
   * Return a Property's value.
   * 
   * This method overrides {@link baja.Complex#get} and checks to see if
   * the Property has been overridden by any associated bindings..
   *
   * @see baja.Complex#get
   *
   * @param {baja.Slot|String} [slot]  the Slot or Slot name
   *
   * @return the value for the Property (or null if the Property doesn't exist)
   */

  Widget.prototype.get = function (slot) {
    var origGet = Component.prototype.get,
        val = null; // If there are definitely no bindings just use the original get

    if (this.$hasNoBindings) {
      return origGet.apply(this, arguments);
    } // Get the Slot


    slot = this.getSlot(slot); // Bail if there's no Slot

    if (!slot) {
      return null;
    } // Get cached overridden access


    if (typeof slot.$isOverridden === "boolean") {
      if (slot.$isOverridden) {
        val = slot.$binding.getOnWidget(slot);

        if (val === null) {
          return origGet.apply(this, arguments);
        }
      } else {
        return origGet.apply(this, arguments);
      }
    }

    var binding,
        p,
        map = this.$map.$map; // Access internal OrderedMap internally for speed

    for (p in map) {
      if (map.hasOwnProperty(p) && map[p].isProperty() && map[p].getType().isComponent() && map[p].getType().is("bajaui:Binding")) {
        binding = origGet.call(this, map[p]);

        if (binding.isBound()) {
          // Cache whether the slot is overridden for quicker access in the future
          slot.$isOverridden = binding.isOverridden(slot);

          if (slot.$isOverridden) {
            // If the slot is overriden then cache the binding on the Slot
            slot.$binding = binding;
            val = binding.getOnWidget(slot);

            if (val !== null) {
              break;
            }
          }
        }
      }
    } // Cache the fact this Widget has no bindings


    if (!binding) {
      this.$hasNoBindings = true;
    }

    if (val !== null) {
      return val;
    }

    return origGet.apply(this, arguments);
  };
  /**
   * Add mouse over effect to Widget.
   */


  Widget.prototype.addMouseOver = function () {
    if (this.$dom) {
      this.$dom.addClass("widgetMouseOver");
    }
  };

  function findRootContainer(widget) {
    if (widget === null) {
      return null;
    }

    if (widget.getType().is("bajaui:RootContainer")) {
      return widget;
    } else {
      return findRootContainer(widget.getParent());
    }
  }
  /**
   * Return the root container of the Widget tree.
   */


  Widget.prototype.getRootContainer = function () {
    if (!this.$root) {
      this.$root = findRootContainer(this);
    }

    return this.$root;
  };
  /**
   * Layout the child Widget.
   * 
   * Gives a parent Widget a chance to layout a child Widget. By default,
   * this does nothing.
   *
   * @function
   *
   * @param {Widget} childWidget the Child Widget to be laid out.
   */


  Widget.prototype.layoutChild = noop;
  /**
   * Return the preferred Width of the Widget. By default, this will return the
   * DOM element's width.
   *
   * @returns {Number} the width in pixels.
   */

  Widget.prototype.getPreferredWidth = function () {
    return this.$dom.width();
  };
  /**
   * Return the preferred Height of the Widget. By default, this will return 
   * the DOM element's height.
   *
   * @returns {Number} the height in pixels.
   */


  Widget.prototype.getPreferredHeight = function () {
    return this.$dom.height();
  };
  /**
   * @returns {Boolean} true if this Widget is absolutely positioned.
   */


  Widget.prototype.isAbsolutelyPositioned = function () {
    var parent = this.getParent();
    return !!(parent && parent.getType().is("bajaui:CanvasPane"));
  };

  return Widget;
});
