/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview Slider class
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */
define(['baja!', 'jquery', 'jquerymobile', 'mobile/px/widgets/Widget'], function (baja, $, jqm, Widget) {
  "use strict";

  var callSuper = baja.callSuper,
      sliderIdCounter = 0,
      SLIDER_HTML = "<div class='mobileSlider' style='text-align: center' data-role='fieldcontain'>" + "<label style='display: none;' for='{id}'></label>" + "<input type='range' data-role='slider' name='slider' id='{id}' value='0' min='{min}' " + "max='{max}' step='{increment}' style='display: none;' data-theme='a' />" + "</div>";
  /**
   * @class Slider.
   *
   * The Widget that represents Niagara's 'bajaui:Slider' Type.
   *
   * @name Slider
   * @extends Widget
   */

  function Slider() {
    callSuper(Slider, this, arguments);
    this.$input = null;
    this.$sliderId = null;
  }

  baja.subclass(Slider, Widget);
  /**
   * Called after the Widget has loaded and any enhancements have 
   * been made to the DOM.
   */

  Slider.prototype.postLoad = function () {
    var that = this,
        input = that.$input = $("#" + that.$sliderId, this.$dom.parent()); // Throttle this so it doesn't happen too often

    var throttledFunc = baja.throttle(function () {
      // Update the Widget with the new value
      that.setValue(Number.DEFAULT.decodeFromString(input.val()));
      that.handleEvent("slide");
    }, 500);
    input.on("change", function (event, ui) {
      throttledFunc();
    });
    this.$dom.find("div.ui-slider").css("width", "90%");
  };
  /**
   * Update the DOM associated with this Widget.
   *
   * @param {Function} hasUpdate called to test whether a 
   *                               given Property can update the DOM.
   */


  Slider.prototype.doUpdate = function (hasUpdate) {
    var that = this,
        input = that.$input,
        value = that.getValue();

    if (hasUpdate("enabled")) {
      input.slider(that.isEnabled() ? "enable" : "disable");
    }

    if (hasUpdate("min")) {
      input.attr("min", that.getMin());
    }

    if (hasUpdate("max")) {
      input.attr("max", that.getMax());
    }

    if (hasUpdate("value")) {
      input.val(value);
    }

    if (hasUpdate("increment")) {
      input.attr("step", that.getIncrement());
    }

    input.slider('refresh', value);
  };
  /**
   * Append the Widget's DOM content onto the specified DOM element.
   *
   * @name Slider#load
   * @function
   *
   * @param {Object} dom DOM element to append content too.
   */


  Slider.prototype.load = function (dom) {
    // Create a unique slider id
    this.$sliderId = "slider" + sliderIdCounter++; // Create the DOM object

    var slider = this.$dom = $(SLIDER_HTML.patternReplace({
      id: this.$sliderId,
      min: this.getMin().toString(),
      max: this.getMax().toString(),
      increment: this.getIncrement().toString()
    })); // Append to the DOM    

    slider.appendTo(dom);
  };

  return Slider;
});
